//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.request;

import cn.com.antcloud.api.bccr.v1_0_0.model.ProxyData;
import cn.com.antcloud.api.bccr.v1_0_0.response.CreateMonitorTaskResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 新增版权监测任务 */
public class CreateMonitorTaskRequest extends AntCloudProdRequest<CreateMonitorTaskResponse> {
  @NotNull
  private String submitContent;

  private String submitType;

  @NotNull
  private String fileType;

  @NotNull
  private String taskName;

  @NotNull
  private String contentTitle;

  @NotNull
  private List<String> keywords;

  private String contentDesc;

  private String providerId;

  private List<String> scopes;

  private Long taskStart;

  private Long taskDuration;

  private ProxyData proxyInfo;

  @NotNull
  private String clientToken;

  public CreateMonitorTaskRequest(String productInstanceId) {
    super("blockchain.bccr.monitor.task.create", "1.0", "Java-SDK-20211221", productInstanceId);
  }

  public CreateMonitorTaskRequest() {
    super("blockchain.bccr.monitor.task.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20211221");
  }

  /**
   * submitType是url就传 url地址 submitType 是file就传 oss fileId */
  public String getSubmitContent() {
    return this.submitContent;
  }

  /**
   * submitType是url就传 url地址 submitType 是file就传 oss fileId */
  public void setSubmitContent(String submitContent) {
    this.submitContent = submitContent;
  }

  /**
   * 提交任务的类型:FILE/URL
   * 不填为FILE
   * FILE表示文件上传素材，URL表示上传URL */
  public String getSubmitType() {
    return this.submitType;
  }

  /**
   * 提交任务的类型:FILE/URL
   * 不填为FILE
   * FILE表示文件上传素材，URL表示上传URL */
  public void setSubmitType(String submitType) {
    this.submitType = submitType;
  }

  /**
   * 文件类别
   *
   * IMAGE
   *
   * TEXT
   *
   * VIDEO */
  public String getFileType() {
    return this.fileType;
  }

  /**
   * 文件类别
   *
   * IMAGE
   *
   * TEXT
   *
   * VIDEO */
  public void setFileType(String fileType) {
    this.fileType = fileType;
  }

  /**
   * 任务名称(不超过100字符) */
  public String getTaskName() {
    return this.taskName;
  }

  /**
   * 任务名称(不超过100字符) */
  public void setTaskName(String taskName) {
    this.taskName = taskName;
  }

  /**
   * 监测任务标题(不超过100字符) */
  public String getContentTitle() {
    return this.contentTitle;
  }

  /**
   * 监测任务标题(不超过100字符) */
  public void setContentTitle(String contentTitle) {
    this.contentTitle = contentTitle;
  }

  /**
   * 关键词(不超过200字符) */
  public List<String> getKeywords() {
    return this.keywords;
  }

  /**
   * 关键词(不超过200字符) */
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }

  /**
   * 内容表述(不超过1000字符) */
  public String getContentDesc() {
    return this.contentDesc;
  }

  /**
   * 内容表述(不超过1000字符) */
  public void setContentDesc(String contentDesc) {
    this.contentDesc = contentDesc;
  }

  /**
   * 监测供应商id */
  public String getProviderId() {
    return this.providerId;
  }

  /**
   * 监测供应商id */
  public void setProviderId(String providerId) {
    this.providerId = providerId;
  }

  /**
   * 监测范围 默认全部：ALL；PC网站：SITE；APP应用：APP */
  public List<String> getScopes() {
    return this.scopes;
  }

  /**
   * 监测范围 默认全部：ALL；PC网站：SITE；APP应用：APP */
  public void setScopes(List<String> scopes) {
    this.scopes = scopes;
  }

  /**
   * 任务开始时间，如当前时间戳，不传则取服务器当前时间戳，单位毫秒 */
  public Long getTaskStart() {
    return this.taskStart;
  }

  /**
   * 任务开始时间，如当前时间戳，不传则取服务器当前时间戳，单位毫秒 */
  public void setTaskStart(Long taskStart) {
    this.taskStart = taskStart;
  }

  /**
   * 任务持续时间，单位天，默认90天
   *
   * 一次性监测：0 */
  public Long getTaskDuration() {
    return this.taskDuration;
  }

  /**
   * 任务持续时间，单位天，默认90天
   *
   * 一次性监测：0 */
  public void setTaskDuration(Long taskDuration) {
    this.taskDuration = taskDuration;
  }

  /**
   * 代理信息 */
  public ProxyData getProxyInfo() {
    return this.proxyInfo;
  }

  /**
   * 代理信息 */
  public void setProxyInfo(ProxyData proxyInfo) {
    this.proxyInfo = proxyInfo;
  }

  /**
   * 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。clientToken只支持ASCII字符，且不能超过64个字符。更多详情，请参见如何保证幂等性。 */
  public String getClientToken() {
    return this.clientToken;
  }

  /**
   * 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。clientToken只支持ASCII字符，且不能超过64个字符。更多详情，请参见如何保证幂等性。 */
  public void setClientToken(String clientToken) {
    this.clientToken = clientToken;
  }
}
