//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.request;

import cn.com.antcloud.api.bccr.v1_0_0.model.ProxyData;
import cn.com.antcloud.api.bccr.v1_0_0.response.CreateCertificateResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 版权平台生成版权登记证书 */
public class CreateCertificateRequest extends AntCloudProdRequest<CreateCertificateResponse> {
  @NotNull
  private String registerId;

  @NotNull
  private String certificateType;

  @NotNull
  private String featuresType;

  private String orgId;

  private ProxyData proxyInfo;

  public CreateCertificateRequest(String productInstanceId) {
    super("blockchain.bccr.certificate.create", "1.0", "Java-SDK-20211221", productInstanceId);
  }

  public CreateCertificateRequest() {
    super("blockchain.bccr.certificate.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20211221");
  }

  /**
   * 版权登记id */
  public String getRegisterId() {
    return this.registerId;
  }

  /**
   * 版权登记id */
  public void setRegisterId(String registerId) {
    this.registerId = registerId;
  }

  /**
   * 证书类型 */
  public String getCertificateType() {
    return this.certificateType;
  }

  /**
   * 证书类型 */
  public void setCertificateType(String certificateType) {
    this.certificateType = certificateType;
  }

  /**
   * 功能类型 */
  public String getFeaturesType() {
    return this.featuresType;
  }

  /**
   * 功能类型 */
  public void setFeaturesType(String featuresType) {
    this.featuresType = featuresType;
  }

  /**
   * 公证处id */
  public String getOrgId() {
    return this.orgId;
  }

  /**
   * 公证处id */
  public void setOrgId(String orgId) {
    this.orgId = orgId;
  }

  /**
   * 代理信息 */
  public ProxyData getProxyInfo() {
    return this.proxyInfo;
  }

  /**
   * 代理信息 */
  public void setProxyInfo(ProxyData proxyInfo) {
    this.proxyInfo = proxyInfo;
  }
}
