//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 公证处信息 */
public class NotaryPublicOffice {
  @NotNull
  private String code;

  @NotNull
  private String name;

  @NotNull
  private String province;

  @NotNull
  private String city;

  /**
   * 公证处code */
  public String getCode() {
    return this.code;
  }

  /**
   * 公证处code */
  public void setCode(String code) {
    this.code = code;
  }

  /**
   * 公证处名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 公证处名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 公证处所在省（直辖市） */
  public String getProvince() {
    return this.province;
  }

  /**
   * 公证处所在省（直辖市） */
  public void setProvince(String province) {
    this.province = province;
  }

  /**
   * 公证处所在市 */
  public String getCity() {
    return this.city;
  }

  /**
   * 公证处所在市 */
  public void setCity(String city) {
    this.city = city;
  }
}
