//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 监测任务信息 */
public class MonitorTask {
  private String contentDesc;

  private String contentTitle;

  private Long fileLengthInSecond;

  @NotNull
  private List<String> keywords;

  @NotNull
  private String monitorTaskId;

  @NotNull
  private String name;

  private String providerId;

  private Long resultCount;

  @NotNull
  private List<String> scopes;

  @NotNull
  private String status;

  @NotNull
  private Long taskDuration;

  private Long taskEnd;

  private Long taskStart;

  @NotNull
  private String fileType;

  private Long fileSize;

  @NotNull
  private String submitContent;

  private String submitType;

  private String failureMsg;

  /**
   * 内容表述
   *
   */
  public String getContentDesc() {
    return this.contentDesc;
  }

  /**
   * 内容表述
   *
   */
  public void setContentDesc(String contentDesc) {
    this.contentDesc = contentDesc;
  }

  /**
   * 监测任务标题
   *
   */
  public String getContentTitle() {
    return this.contentTitle;
  }

  /**
   * 监测任务标题
   *
   */
  public void setContentTitle(String contentTitle) {
    this.contentTitle = contentTitle;
  }

  /**
   * 监测文件时长，主要用于视频监测、音频监测的时长记录 */
  public Long getFileLengthInSecond() {
    return this.fileLengthInSecond;
  }

  /**
   * 监测文件时长，主要用于视频监测、音频监测的时长记录 */
  public void setFileLengthInSecond(Long fileLengthInSecond) {
    this.fileLengthInSecond = fileLengthInSecond;
  }

  /**
   * 监测关键字
   *
   */
  public List<String> getKeywords() {
    return this.keywords;
  }

  /**
   * 监测关键字
   *
   */
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }

  /**
   * 监测任务ID
   */
  public String getMonitorTaskId() {
    return this.monitorTaskId;
  }

  /**
   * 监测任务ID
   */
  public void setMonitorTaskId(String monitorTaskId) {
    this.monitorTaskId = monitorTaskId;
  }

  /**
   * 任务名称
   *
   */
  public String getName() {
    return this.name;
  }

  /**
   * 任务名称
   *
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 监测供应商id */
  public String getProviderId() {
    return this.providerId;
  }

  /**
   * 监测供应商id */
  public void setProviderId(String providerId) {
    this.providerId = providerId;
  }

  /**
   * 监测结果数量
   *
   */
  public Long getResultCount() {
    return this.resultCount;
  }

  /**
   * 监测结果数量
   *
   */
  public void setResultCount(Long resultCount) {
    this.resultCount = resultCount;
  }

  /**
   * 监测范围
   *
   */
  public List<String> getScopes() {
    return this.scopes;
  }

  /**
   * 监测范围
   *
   */
  public void setScopes(List<String> scopes) {
    this.scopes = scopes;
  }

  /**
   * 任务状态
   *
   * INIT
   *
   * WORKING
   *
   * FINISH
   *
   * FAILURE
   *
   * DELETE */
  public String getStatus() {
    return this.status;
  }

  /**
   * 任务状态
   *
   * INIT
   *
   * WORKING
   *
   * FINISH
   *
   * FAILURE
   *
   * DELETE */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 监测时长(天)
   *
   */
  public Long getTaskDuration() {
    return this.taskDuration;
  }

  /**
   * 监测时长(天)
   *
   */
  public void setTaskDuration(Long taskDuration) {
    this.taskDuration = taskDuration;
  }

  /**
   * 任务结束时间
   *
   */
  public Long getTaskEnd() {
    return this.taskEnd;
  }

  /**
   * 任务结束时间
   *
   */
  public void setTaskEnd(Long taskEnd) {
    this.taskEnd = taskEnd;
  }

  /**
   * 任务开始时间
   *
   */
  public Long getTaskStart() {
    return this.taskStart;
  }

  /**
   * 任务开始时间
   *
   */
  public void setTaskStart(Long taskStart) {
    this.taskStart = taskStart;
  }

  /**
   * 文件类别
   *
   * IMAGE
   *
   * TEXT
   *
   * VIDEO */
  public String getFileType() {
    return this.fileType;
  }

  /**
   * 文件类别
   *
   * IMAGE
   *
   * TEXT
   *
   * VIDEO */
  public void setFileType(String fileType) {
    this.fileType = fileType;
  }

  /**
   * 文件大小 */
  public Long getFileSize() {
    return this.fileSize;
  }

  /**
   * 文件大小 */
  public void setFileSize(Long fileSize) {
    this.fileSize = fileSize;
  }

  /**
   * submitType是url就是url地址 submitType 是file就是oss fileId */
  public String getSubmitContent() {
    return this.submitContent;
  }

  /**
   * submitType是url就是url地址 submitType 是file就是oss fileId */
  public void setSubmitContent(String submitContent) {
    this.submitContent = submitContent;
  }

  /**
   * 提交任务的类型:FILE/URL
   * 不填为FILE
   * FILE表示文件上传素材，URL表示上传URL */
  public String getSubmitType() {
    return this.submitType;
  }

  /**
   * 提交任务的类型:FILE/URL
   * 不填为FILE
   * FILE表示文件上传素材，URL表示上传URL */
  public void setSubmitType(String submitType) {
    this.submitType = submitType;
  }

  /**
   * 当status为failure时的具体错误信息 */
  public String getFailureMsg() {
    return this.failureMsg;
  }

  /**
   * 当status为failure时的具体错误信息 */
  public void setFailureMsg(String failureMsg) {
    this.failureMsg = failureMsg;
  }
}
