//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.model;

import java.lang.Boolean;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 监测提供商能力 */
public class MonitorProviderCapability {
  @NotNull
  private String providerId;

  @NotNull
  private String providerName;

  @NotNull
  private String providerDescription;

  @NotNull
  private Boolean isProvided;

  /**
   * 供应商id */
  public String getProviderId() {
    return this.providerId;
  }

  /**
   * 供应商id */
  public void setProviderId(String providerId) {
    this.providerId = providerId;
  }

  /**
   * 供应商名称 */
  public String getProviderName() {
    return this.providerName;
  }

  /**
   * 供应商名称 */
  public void setProviderName(String providerName) {
    this.providerName = providerName;
  }

  /**
   * 供应商描述 */
  public String getProviderDescription() {
    return this.providerDescription;
  }

  /**
   * 供应商描述 */
  public void setProviderDescription(String providerDescription) {
    this.providerDescription = providerDescription;
  }

  /**
   * 是否推荐供应商 */
  public Boolean getIsProvided() {
    return this.isProvided;
  }

  /**
   * 是否推荐供应商 */
  public void setIsProvided(Boolean isProvided) {
    this.isProvided = isProvided;
  }
}
