/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util.sort;

import java.text.DecimalFormatSymbols;
import java.util.Comparator;
import java.util.Locale;
import org.unix4j.util.sort.TrimBlanksStringComparator;

public class DecimalNumberStringComparator
implements Comparator<CharSequence> {
    private static final DecimalNumberStringComparator DEFAULT_INSTANCE = new DecimalNumberStringComparator();
    private final DecimalFormatSymbols symbols;

    public static DecimalNumberStringComparator getInstance() {
        return DEFAULT_INSTANCE;
    }

    public static DecimalNumberStringComparator getInstance(Locale locale) {
        return new DecimalNumberStringComparator(locale);
    }

    private DecimalNumberStringComparator() {
        this(DecimalFormatSymbols.getInstance());
    }

    private DecimalNumberStringComparator(Locale locale) {
        this(DecimalFormatSymbols.getInstance(locale));
    }

    public DecimalNumberStringComparator(DecimalFormatSymbols symbols) {
        this.symbols = symbols;
    }

    @Override
    public int compare(CharSequence s1, CharSequence s2) {
        int start1 = TrimBlanksStringComparator.findStartTrimBlanks(s1);
        int start2 = TrimBlanksStringComparator.findStartTrimBlanks(s2);
        return this.compare(s1, start1, s1.length(), s2, start2, s2.length());
    }

    private int compare(CharSequence s1, int start1, int end1, CharSequence s2, int start2, int end2) {
        char decimalSeparator = this.symbols.getDecimalSeparator();
        char groupingSeparator = this.symbols.getGroupingSeparator();
        char zeroDigit = this.symbols.getZeroDigit();
        boolean isNeg1 = start1 < end1 && s1.charAt(start1) == '-';
        boolean isNeg2 = start2 < end2 && s2.charAt(start2) == '-';
        int index1 = this.skipLeadingZeroChars(s1, isNeg1 ? start1 + 1 : start1, end1, zeroDigit);
        int index2 = this.skipLeadingZeroChars(s2, isNeg2 ? start2 + 1 : start2, end2, zeroDigit);
        int cmp = 0;
        boolean isZero1 = true;
        boolean isZero2 = true;
        while (index1 < end1 || index2 < end2) {
            index1 = this.skipGroupingSeparatorChars(s1, index1, end1, groupingSeparator);
            index2 = this.skipGroupingSeparatorChars(s2, index2, end2, groupingSeparator);
            char ch1 = index1 < end1 ? (char)s1.charAt(index1) : (char)'\n';
            char ch2 = index2 < end2 ? (char)s2.charAt(index2) : (char)'\n';
            boolean isDigit1 = Character.isDigit(ch1);
            boolean isDigit2 = Character.isDigit(ch2);
            if (isDigit1 && isDigit2) {
                isZero1 &= isDigit1 && ch1 == zeroDigit;
                isZero2 &= isDigit2 && ch2 == zeroDigit;
                if (cmp == 0) {
                    cmp = ch1 - ch2;
                }
                ++index1;
                ++index2;
                continue;
            }
            if (ch1 == decimalSeparator || ch2 == decimalSeparator) {
                return this.compareAfterDecimals(s1, index1, end1, ch1, isNeg1, isZero1, s2, index2, end2, ch2, isNeg2, isZero2, cmp);
            }
            if (isDigit1) {
                return this.applySign(1, isNeg1, isNeg2);
            }
            if (isDigit2) {
                return this.applySign(-1, isNeg1, isNeg2);
            }
            if (cmp == 0) {
                cmp = ch1 - ch2;
            }
            ++index1;
            ++index2;
        }
        return this.applySign(cmp, isNeg1 && !isZero1, isNeg2 && !isZero2);
    }

    private int compareAfterDecimals(CharSequence s1, int index1, int end1, char ch1, boolean isNeg1, boolean isZero1, CharSequence s2, int index2, int end2, char ch2, boolean isNeg2, boolean isZero2, int cmp) {
        boolean isDecimal2;
        char decimalSeparator = this.symbols.getDecimalSeparator();
        char zeroDigit = this.symbols.getZeroDigit();
        boolean isDigit1 = Character.isDigit(ch1);
        boolean isDigit2 = Character.isDigit(ch2);
        boolean isDecimal1 = ch1 == decimalSeparator;
        boolean bl = isDecimal2 = ch2 == decimalSeparator;
        if (isDigit1 && !isDecimal1 && isDecimal2) {
            return this.applySign(1, isNeg1, isNeg2);
        }
        if (isDigit2 && isDecimal1 && !isDecimal2) {
            return this.applySign(-1, isNeg1, isNeg2);
        }
        if (cmp != 0) {
            return this.applySign(cmp, isNeg1 && !isZero1, isNeg2 && !isZero2);
        }
        if (isDecimal1) {
            ++index1;
        }
        if (isDecimal2) {
            ++index2;
        }
        while (cmp == 0 && (index1 < end1 || index2 < end2)) {
            ch1 = (char)(index1 < end1 ? (int)s1.charAt(index1) : 10);
            ch2 = (char)(index2 < end2 ? (int)s2.charAt(index2) : 10);
            isDigit1 = Character.isDigit(ch1);
            isDigit2 = Character.isDigit(ch2);
            if (isDigit1 && isDigit2) {
                isZero1 &= isDigit1 && ch1 == zeroDigit;
                isZero2 &= isDigit2 && ch2 == zeroDigit;
                cmp = ch1 - ch2;
                ++index1;
                ++index2;
                continue;
            }
            if (isDigit1) {
                if (ch1 == zeroDigit && isDecimal1) {
                    ++index1;
                    continue;
                }
                return this.applySign(1, isNeg1, isNeg2);
            }
            if (isDigit2) {
                if (ch2 == zeroDigit && isDecimal2) {
                    ++index2;
                    continue;
                }
                return this.applySign(-1, isNeg1, isNeg2);
            }
            cmp = ch1 - ch2;
            ++index1;
            ++index2;
        }
        return this.applySign(cmp, isNeg1 && !isZero1, isNeg2 && !isZero2);
    }

    private int applySign(int cmp, boolean isNeg1, boolean isNeg2) {
        if (isNeg1) {
            return isNeg2 ? -cmp : -1;
        }
        return isNeg2 ? 1 : cmp;
    }

    private int skipLeadingZeroChars(CharSequence s, int index, int end, char zeroDigit) {
        while (index < end) {
            char ch = s.charAt(index);
            if (ch == zeroDigit) {
                ++index;
                continue;
            }
            return index;
        }
        return end;
    }

    private int skipGroupingSeparatorChars(CharSequence s, int index, int end, char groupingSeparator) {
        if (index < end && s.charAt(index) == groupingSeparator) {
            return index + 1;
        }
        return index;
    }
}

