/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.convert;

import org.unix4j.convert.CompositeValueConverter;
import org.unix4j.convert.ValueConverter;

public class CharacterConverters {
    public static final ValueConverter<Character> INTEGER_TO_CHARACTER = new ValueConverter<Character>(){

        @Override
        public Character convert(Object value) throws IllegalArgumentException {
            if (value instanceof Integer) {
                return Character.valueOf((char)((Integer)value).intValue());
            }
            return null;
        }
    };
    public static final ValueConverter<Character> STRING_TO_CHARACTER = new ValueConverter<Character>(){

        @Override
        public Character convert(Object value) throws IllegalArgumentException {
            String s;
            if (value != null && (s = value.toString()).length() > 0) {
                return Character.valueOf(s.charAt(0));
            }
            return null;
        }
    };
    public static final ValueConverter<Character> DEFAULT = new CompositeValueConverter<Character>().add(INTEGER_TO_CHARACTER).add(STRING_TO_CHARACTER);
}

