/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Simon;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.CallbackSkeleton;

public final class SystemDebugCallback
extends CallbackSkeleton {
    public static final String DEBUG_PREFIX = "SIMON DEBUG: ";

    @Override
    public void onSimonReset(Simon simon) {
        this.out("Simon reset: " + simon);
    }

    @Override
    public void onStopwatchStart(Split split) {
        this.out("Start split: " + split);
    }

    @Override
    public void onStopwatchStop(Split split, StopwatchSample sample) {
        this.out("Stopwatch stop (" + split + "): " + sample.simonToString());
    }

    @Override
    public void onStopwatchAdd(Stopwatch stopwatch, Split split, StopwatchSample sample) {
        this.out("Stopwatch add (" + split + "): " + sample.simonToString());
    }

    @Override
    public void onCounterDecrease(Counter counter, long dec, CounterSample sample) {
        this.out("Counter decrease: " + sample.simonToString());
    }

    @Override
    public void onCounterIncrease(Counter counter, long inc, CounterSample sample) {
        this.out("Counter increase: " + sample.simonToString());
    }

    @Override
    public void onCounterSet(Counter counter, long val, CounterSample sample) {
        this.out("Counter set: " + sample.simonToString());
    }

    @Override
    public void onSimonCreated(Simon simon) {
        this.out("Simon created: " + simon);
    }

    @Override
    public void onSimonDestroyed(Simon simon) {
        this.out("Simon destroyed: " + simon);
    }

    @Override
    public void onManagerClear() {
        this.out("Manager clear");
    }

    @Override
    public void onManagerMessage(String message) {
        this.out("Simon message: " + message);
    }

    private void out(String message) {
        System.out.println(DEBUG_PREFIX + message);
    }

    @Override
    public void onManagerWarning(String warning, Exception cause) {
        if (warning != null) {
            System.err.println("SIMON DEBUG: Simon warning: " + warning);
        }
        if (cause != null) {
            System.err.print(DEBUG_PREFIX);
            cause.printStackTrace();
        }
    }
}

