/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric;

import com.netflix.hystrix.ExecutionResult;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixInvokableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HystrixRequestEvents {
    private final Collection<HystrixInvokableInfo<?>> executions;

    public HystrixRequestEvents(Collection<HystrixInvokableInfo<?>> executions) {
        this.executions = executions;
    }

    public Collection<HystrixInvokableInfo<?>> getExecutions() {
        return this.executions;
    }

    public Map<ExecutionSignature, List<Integer>> getExecutionsMappedToLatencies() {
        HashMap<CommandAndCacheKey, Integer> cachingDetector = new HashMap<CommandAndCacheKey, Integer>();
        ArrayList nonCachedExecutions = new ArrayList(this.executions.size());
        for (HystrixInvokableInfo<?> execution : this.executions) {
            if (execution.getPublicCacheKey() != null) {
                CommandAndCacheKey commandAndCacheKey = new CommandAndCacheKey(execution.getCommandKey().name(), execution.getPublicCacheKey());
                Integer count = (Integer)cachingDetector.get(commandAndCacheKey);
                if (count != null) {
                    cachingDetector.put(commandAndCacheKey, count + 1);
                } else {
                    cachingDetector.put(commandAndCacheKey, 0);
                }
            }
            if (execution.isResponseFromCache()) continue;
            nonCachedExecutions.add(execution);
        }
        HashMap<ExecutionSignature, List<Integer>> commandDeduper = new HashMap<ExecutionSignature, List<Integer>>();
        for (HystrixInvokableInfo hystrixInvokableInfo : nonCachedExecutions) {
            int cachedCount = 0;
            String cacheKey = null;
            if (hystrixInvokableInfo.getPublicCacheKey() != null) {
                cacheKey = hystrixInvokableInfo.getPublicCacheKey();
                CommandAndCacheKey key = new CommandAndCacheKey(hystrixInvokableInfo.getCommandKey().name(), cacheKey);
                cachedCount = (Integer)cachingDetector.get(key);
            }
            HystrixCollapserKey collapserKey = hystrixInvokableInfo.getOriginatingCollapserKey();
            int collapserBatchCount = hystrixInvokableInfo.getNumberCollapsed();
            ExecutionSignature signature = cachedCount > 0 ? ExecutionSignature.from(hystrixInvokableInfo, cacheKey, cachedCount) : ExecutionSignature.from(hystrixInvokableInfo);
            List currentLatencyList = (List)commandDeduper.get(signature);
            if (currentLatencyList != null) {
                currentLatencyList.add(hystrixInvokableInfo.getExecutionTimeInMilliseconds());
                continue;
            }
            ArrayList<Integer> newLatencyList = new ArrayList<Integer>();
            newLatencyList.add(hystrixInvokableInfo.getExecutionTimeInMilliseconds());
            commandDeduper.put(signature, newLatencyList);
        }
        return commandDeduper;
    }

    public static class ExecutionSignature {
        private final String commandName;
        private final ExecutionResult.EventCounts eventCounts;
        private final String cacheKey;
        private final int cachedCount;
        private final HystrixCollapserKey collapserKey;
        private final int collapserBatchSize;

        private ExecutionSignature(HystrixCommandKey commandKey, ExecutionResult.EventCounts eventCounts, String cacheKey, int cachedCount, HystrixCollapserKey collapserKey, int collapserBatchSize) {
            this.commandName = commandKey.name();
            this.eventCounts = eventCounts;
            this.cacheKey = cacheKey;
            this.cachedCount = cachedCount;
            this.collapserKey = collapserKey;
            this.collapserBatchSize = collapserBatchSize;
        }

        public static ExecutionSignature from(HystrixInvokableInfo<?> execution) {
            return new ExecutionSignature(execution.getCommandKey(), execution.getEventCounts(), null, 0, execution.getOriginatingCollapserKey(), execution.getNumberCollapsed());
        }

        public static ExecutionSignature from(HystrixInvokableInfo<?> execution, String cacheKey, int cachedCount) {
            return new ExecutionSignature(execution.getCommandKey(), execution.getEventCounts(), cacheKey, cachedCount, execution.getOriginatingCollapserKey(), execution.getNumberCollapsed());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionSignature that = (ExecutionSignature)o;
            if (!this.commandName.equals(that.commandName)) {
                return false;
            }
            if (!this.eventCounts.equals(that.eventCounts)) {
                return false;
            }
            return !(this.cacheKey == null ? that.cacheKey != null : !this.cacheKey.equals(that.cacheKey));
        }

        public int hashCode() {
            int result = this.commandName.hashCode();
            result = 31 * result + this.eventCounts.hashCode();
            result = 31 * result + (this.cacheKey != null ? this.cacheKey.hashCode() : 0);
            return result;
        }

        public String getCommandName() {
            return this.commandName;
        }

        public ExecutionResult.EventCounts getEventCounts() {
            return this.eventCounts;
        }

        public int getCachedCount() {
            return this.cachedCount;
        }

        public HystrixCollapserKey getCollapserKey() {
            return this.collapserKey;
        }

        public int getCollapserBatchSize() {
            return this.collapserBatchSize;
        }
    }

    private static class CommandAndCacheKey {
        private final String commandName;
        private final String cacheKey;

        public CommandAndCacheKey(String commandName, String cacheKey) {
            this.commandName = commandName;
            this.cacheKey = cacheKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommandAndCacheKey that = (CommandAndCacheKey)o;
            if (!this.commandName.equals(that.commandName)) {
                return false;
            }
            return this.cacheKey.equals(that.cacheKey);
        }

        public int hashCode() {
            int result = this.commandName.hashCode();
            result = 31 * result + this.cacheKey.hashCode();
            return result;
        }

        public String toString() {
            return "CommandAndCacheKey{commandName='" + this.commandName + '\'' + ", cacheKey='" + this.cacheKey + '\'' + '}';
        }
    }
}

