package com.jz.website.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.website.Tables;
import com.jz.jooq.website.tables.pojos.Banner;

@Lazy
@Repository
public class BannerRepository extends WebsiteBaseRepository {

	private static final com.jz.jooq.website.tables.Banner BA = Tables.BANNER;

	public List<Banner> getBannerInfo(List<String> schools, String bid) {
		return websiteCtx.selectFrom(BA).where(BA.CREATOR_SCHOOL_ID.in(schools).and(BA.BID.eq(bid))).orderBy(BA.SEQ)
				.fetchInto(Banner.class);
	}

}
