package com.jz.website.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.website.Tables;
import com.jz.jooq.website.tables.pojos.SchoolIntro;

@Lazy
@Repository
public class SchoolIntroRepository extends WebsiteBaseRepository {

	private static final com.jz.jooq.website.tables.SchoolIntro SI = Tables.SCHOOL_INTRO;

	public SchoolIntro getSchoolIntro(String schoolId) {
		return ArrayMapTools.getFirst(websiteCtx.selectFrom(SI).where(SI.SCHOOL_ID.eq(schoolId)).fetchInto(SchoolIntro.class));
	}

}
