package com.jz.service;

import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.jz.beans.AliyunClient;
import com.jz.config.GymchinaSmsAccess;
import com.jz.config.SmsConfiguration;
import com.jz.sms.enums.Sign;

@Service
public class SmsContractService {

	private static final Logger logger = LoggerFactory.getLogger(SmsContractService.class);

	public Pair<Boolean, String> sendContractNotice(String phone, String schoolName, Sign sign) throws Exception {
		GymchinaSmsAccess accessInfo = SmsConfiguration.getAccessInfo(sign, Core.contract);
		if (null == accessInfo)
			return Pair.of(false, "无法获取账户信息");
		AliyunClient aliyunClient = AliyunClient.of(phone, sign.used, accessInfo.getTemplateCode());
		aliyunClient.addTemplateParam("school", sign.used + schoolName);
		aliyunClient.setEndpointName(accessInfo.getEndpointName());
		String msg = AliyunInvokeService.sendSms(accessInfo.getKeyId(), accessInfo.getKeySecret(), aliyunClient);
		if (null == msg)
			return Pair.of(true, null);
		logger.error("[" + phone + "] send sms error : " + msg);
		return Pair.of(false, msg);
	}

}
