package com.jz.config;

import java.util.Map;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.jz.service.Core;
import com.jz.sms.enums.Sign;

/**
 * @Title SmsConfiguration
 * @Package com.jz.config
 * @author tangjunfeng
 * @date 2019年1月24日 下午4:46:39
 * @version V1.0
 */
@Component
public class SmsConfiguration {

	// playabc | 精中
	@Value("${aliyun.access.playabc.key.id}")
	private String accessKeyId;
	@Value("${aliyun.access.playabc.key.secret}")
	private String accessKeySecret;
	// tomato
	@Value("${aliyun.access.tomato.key.id}")
	private String tomatoAccessKeyId;
	@Value("${aliyun.access.tomato.key.secret}")
	private String tomatoAccessKeySecret;

	// 验证码
	@Value("${aliyun.sms.template.playabc.verification.code}")
	private String playabcTemplateCode;
	@Value("${aliyun.sms.template.tomato.verification.code}")
	private String tomatoTemplateCode;

	// 合同签署
	@Value("${aliyun.sms.template.playabc.contract}")
	private String playabcContract;
	@Value("${aliyun.sms.template.tomato.contract}")
	private String tomatoContract;

	private static Table<Sign, String, GymchinaSmsAccess> sign2Access = HashBasedTable.create();

	@PostConstruct
	public void init() {
		Map<String, String> playabcB2code = Maps.newHashMap();
		playabcB2code.put(Core.verificationCode, playabcTemplateCode);
		playabcB2code.put(Core.contract, playabcContract);

		Map<String, String> tomatoB2code = Maps.newHashMap();
		tomatoB2code.put(Core.verificationCode, tomatoTemplateCode);
		tomatoB2code.put(Core.contract, tomatoContract);

		putAccess(accessKeyId, accessKeySecret, "cn-beijing", playabcB2code, Sign.JingZhong, Sign.PlayABC, Sign.guanmei);
		putAccess(tomatoAccessKeyId, tomatoAccessKeySecret, "cn-shanghai", tomatoB2code, Sign.tomato);

	}

	private void putAccess(String keyId, String keySecret, String endpointName, Map<String, String> b2code,
			Sign... signs) {
		b2code.forEach((bk, code) -> {
			GymchinaSmsAccess access = GymchinaSmsAccess.of(keyId, keySecret, code, endpointName);
			for (Sign sign : signs) {
				sign2Access.put(sign, bk, access);
			}
		});
	}

	public static GymchinaSmsAccess getAccessInfo(Sign sign, String bk) {
		return sign2Access.get(sign, bk);
	}
}
