package com.jz.beans;

import java.util.Map;

import com.google.common.collect.Maps;

public class AliyunClient {

	private String phone;
	private String signName;
	private String template;
	private Map<String, String> templateParams;

	private String endpointName;

	public static AliyunClient of(String phone, String signName, String template) {
		return new AliyunClient().setPhone(phone).setSignName(signName).setTemplate(template);
	}

	public String getPhone() {
		return phone;
	}

	public AliyunClient setPhone(String phone) {
		this.phone = phone;
		return this;
	}

	public String getSignName() {
		return signName;
	}

	public AliyunClient setSignName(String signName) {
		this.signName = signName;
		return this;
	}

	public String getTemplate() {
		return template;
	}

	public AliyunClient setTemplate(String template) {
		this.template = template;
		return this;
	}

	public Map<String, String> getTemplateParams() {
		return templateParams;
	}

	public AliyunClient setTemplateParams(Map<String, String> templateParams) {
		this.templateParams = templateParams;
		return this;
	}

	public AliyunClient addTemplateParam(String key, String value) {
		if (null == key && null == value)
			return this;
		if (null == this.templateParams) {
			this.templateParams = Maps.newHashMap();
		}
		this.templateParams.put(key, value);
		return this;
	}

	public String getEndpointName() {
		return endpointName;
	}

	public AliyunClient setEndpointName(String endpointName) {
		this.endpointName = endpointName;
		return this;
	}

}
