package com.jz.sms;

import java.io.IOException;
import java.util.Map;

import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import com.jz.sms.response.SmsCommonResponse;

@Service
public class SmsClient {

	@Value("${jz.sms.server.send.url}")
	private String SMS_SEND;
	@Value("${jz.sms.server.check.url}")
	private String SMS_CHECK;

	private static SmsClient client;
	private SmsClient() {
		client = this;
	}

	private SmsClient(String send, String check) {
		this.SMS_SEND = send;
		this.SMS_CHECK = check;
	}

	public static SmsClient getClient() {
		return new SmsClient(client.SMS_SEND, client.SMS_CHECK);
	}
	
	/** 发送短信 */
	public boolean sendCode(String phone, String app) throws ClientProtocolException, IOException {
		Map<String, String> params = Maps.newHashMap();
		params.put("phone", phone);
		params.put("app", app);
		// 发送post
		String result = ConnectPost.send(SMS_SEND, params, "UTF-8");
		if (StringTools.isEmptyAndBlank(result))
			return false;
		SmsCommonResponse response = GsonTools.gson.fromJson(result, SmsCommonResponse.class);
		return response.isSuccess();
	}
	
	/** 验证码 */
	public SmsCommonResponse checkCode(String phone, String code, String app) throws ClientProtocolException, IOException {
		Map<String, String> params = Maps.newHashMap();
		params.put("phone", phone);
		params.put("code", code);
		params.put("app", app);
		// 发送post
		String result = ConnectPost.send(SMS_CHECK, params, "UTF-8");
		if (StringTools.isEmptyAndBlank(result))
			return null;
		return GsonTools.gson.fromJson(result, SmsCommonResponse.class);
	}
}