/*
 * Decompiled with CFR 0.152.
 */
package com.jz.shop.jar.service;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.shop.tables.pojos.Supplier;
import com.jz.shop.jar.repository.SupplierRepository;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class SupplierService {
    @Autowired
    private SupplierRepository supplierRepository;

    public Supplier getSupplier(String supplierId) {
        return this.supplierRepository.getSupplier(supplierId);
    }

    public Map<String, Supplier> mutiGetSupplier(Collection<String> supplierIds) {
        List<Supplier> suppliers = this.supplierRepository.mutiGetSupplier(supplierIds);
        if (ArrayMapTools.isEmpty(suppliers)) {
            return null;
        }
        HashMap rsMap = Maps.newHashMap();
        suppliers.forEach(it -> rsMap.put(it.getId(), it));
        return rsMap;
    }

    public int cntSupplier(String type, String keyword) {
        return this.supplierRepository.cntSupplier(type, keyword);
    }

    public List<Supplier> listSupplier(String type, String keyword, int start, int size) {
        return this.supplierRepository.listSupplier(type, keyword, start, size);
    }

    public void createSupplier(String id, String name, String type, String remark) {
        this.supplierRepository.createSupplier(id, name, type, remark);
    }

    public void editSupplier(String id, String name, String type, String remark) {
        this.supplierRepository.editSupplier(id, name, type, remark);
    }

    public void updateSupplierStatus(String id, int status) {
        this.supplierRepository.updateSupplierStatus(id, status);
    }
}

