package com.jz.shop.jar.service;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Table;
import com.jz.jooq.shop.tables.records.GoodsWarehouseStockChangeRecord;
import com.jz.jooq.shop.tables.records.GoodsWarehouseStockRecord;
import com.jz.shop.jar.repository.GoodsWarehouseStockChangeRepository;
import com.jz.shop.jar.repository.GoodsWarehouseStockRepository;

@Lazy
@Repository
public class WarehouseService {

	@Autowired
	private GoodsWarehouseStockRepository stockRepository;
	@Autowired
	private GoodsWarehouseStockChangeRepository stockChangeRepository;

	public Table<String, String, Integer> mutiGetGoodsWarehouseNum(Map<String, String> goodsId2WarehouseId) {
		return stockRepository.mutiGetGoodsWarehouseNum(goodsId2WarehouseId);
	}

	public void insertUpdateGoodsStock(List<GoodsWarehouseStockRecord> stockUpdateRecords,
			List<GoodsWarehouseStockRecord> stockInsertRecords) {
		stockRepository.insertUpdateGoodsStock(stockUpdateRecords, stockInsertRecords);
	}

	public void insertStockChange(List<GoodsWarehouseStockChangeRecord> changeRecords) {
		stockChangeRepository.insertStockChange(changeRecords);
	}

}
