package com.jz.shop.jar.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.shop.Tables;
import com.jz.jooq.shop.tables.pojos.ShippingAddress;

@Lazy
@Repository
public class ShippingAddressRepository extends ShopBaseRepository {

	private static final com.jz.jooq.shop.tables.ShippingAddress A = Tables.SHIPPING_ADDRESS;

	public ShippingAddress getAddress(Integer id, String schoolUserId) {
		return shopCtx.selectFrom(A).where(A.ID.eq(id).and(A.SCHOOL_USER_ID.eq(schoolUserId)))
				.fetchAnyInto(ShippingAddress.class);
	}

}
