package com.jz.shop.jar.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.shop.tables.pojos.Goods;
import com.jz.shop.jar.repository.GoodsRepository;

@Lazy
@Repository
public class GoodsService {

	@Autowired
	private GoodsRepository goodsRepository;

	public Map<String, Goods> mutiGetGoods(Collection<String> gids) {
		List<Goods> goods = goodsRepository.mutiGetGoods(gids);
		Map<String, Goods> rsMap = Maps.newHashMap();
		if (ArrayMapTools.isNotEmpty(goods)) {
			goods.forEach(it -> rsMap.put(it.getId(), it));
		}
		return rsMap;
	}

}
