package com.jz.shop.jar.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.shop.Tables;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class PurchaseOrderRepository extends ShopBaseRepository {

	private static final com.jz.jooq.shop.tables.PurchaseOrder PO = Tables.PURCHASE_ORDER;
	private static final com.jz.jooq.shop.tables.PurchaseOrderGoods POG = Tables.PURCHASE_ORDER_GOODS;

	public List<String> getPayedOrderNos(String schoolUserId) {
		return shopCtx.select(PO.ORDER_NO).from(PO).where(PO.SCHOOL_USER_ID.eq(schoolUserId).and(PO.PAY_TIME.gt(0l)))
				.fetchInto(String.class);
	}

	public boolean existOrderGoods(Collection<String> orderNos, String productId) {
		return shopCtx.fetchExists(POG, POG.ORDER_NO.in(orderNos).and(POG.PRODUCT_ID.eq(productId)));
	}
}
