package com.jz.qcloud.tools;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.jz.common.utils.jz.IdTools;
import com.jz.common.utils.text.StringTools;
import com.jz.qcloud.beans.PreSignedUploadInfo;
import com.jz.qcloud.beans.QcloudConfig;
import com.jz.qcloud.beans.UploadConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.region.Region;

/**
 * @Title 针对于腾讯云对象存获取预签名url
 * @author shaolianjie
 */
public class PresignedUrlTools {

	private QcloudConfig qcloudConfig;

	private PresignedUrlTools() {
	}

	private PresignedUrlTools(QcloudConfig qcloudConfig) {
		super();
		this.qcloudConfig = qcloudConfig;
	}

	public static PresignedUrlTools getInstance(QcloudConfig qcloudConfig) {
		return new PresignedUrlTools(qcloudConfig);
	}

	private COSClient createCOSClient() {
		// 1 初始化用户身份信息（secretId, secretKey）。
		// SECRETID和SECRETKEY请登录访问管理控制台 https://console.cloud.tencent.com/cam/capi
		// 进行查看和管理
		String secretId = qcloudConfig.getAccessKeyId();
		String secretKey = qcloudConfig.getAccessKeySecret();
		COSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
		// 2 设置 bucket 的地域, COS 地域的简称请参照
		// https://cloud.tencent.com/document/product/436/6224
		// clientConfig 中包含了设置 region, https(默认 http), 超时, 代理等 set 方法, 使用可参见源码或者常见问题
		// Java SDK 部分。
		Region region = new Region(qcloudConfig.getRegion());
		ClientConfig clientConfig = new ClientConfig(region);
		// 这里建议设置使用 https 协议
		// 从 5.6.54 版本开始，默认使用了 https
		clientConfig.setHttpProtocol(HttpProtocol.https);
		// 3 生成 cos 客户端。
		return new COSClient(cred, clientConfig);
	}

	/** 获取预上传地址 */
	public PreSignedUploadInfo genPresignedUrl(String identity, String clientFileName, UploadConfig uploadConfig)
			throws Exception {
		COSClient cosClient = createCOSClient();

		String fileId = this.getFileId(identity, clientFileName, uploadConfig);
		String path = uploadConfig.getSaveDir();
		if (!path.startsWith(uploadConfig.getBasePath())) {
			path = uploadConfig.getBasePath() + "/" + path;
		}
		if (!path.endsWith("/")) {
			path += "/";
		}
		path += fileId;
		if (StringUtils.isNotEmpty(uploadConfig.getExt())) {
			path += "." + uploadConfig.getExt();
		}

		String key = path;

		// 设置签名过期时间(可选), 若未进行设置则默认使用 ClientConfig 中的签名过期时间(1小时)
		// 这里设置签名在半个小时后过期
		Date expirationDate = new Date(System.currentTimeMillis() + 7200 * 1000);

		// 填写本次请求的参数，需与实际请求相同，能够防止用户篡改此签名的 HTTP 请求的参数
		Map<String, String> params = new HashMap<String, String>();

		// 填写本次请求的头部，需与实际请求相同，能够防止用户篡改此签名的 HTTP 请求的头部
		Map<String, String> headers = new HashMap<String, String>();
		headers.put("identity", identity);

		// 请求的 HTTP 方法，上传请求用 PUT，下载请求用 GET，删除请求用 DELETE
		HttpMethodName method = uploadConfig.isPost() ? HttpMethodName.POST : HttpMethodName.PUT;

		URL url = cosClient.generatePresignedUrl(qcloudConfig.getBucketName(), key, expirationDate, method, headers,
				params);

		cosClient.shutdown();

		String host = "https://" + qcloudConfig.getBucketName() + ".cos." + qcloudConfig.getRegion() + ".myqcloud.com";
		PreSignedUploadInfo info = PreSignedUploadInfo.of();
		info.setUrl(url.toString());
		if (StringUtils.isNotEmpty(uploadConfig.getCallback())) {
			info.setCallback(this.getCallbackBody(uploadConfig.getCallbackBody(),
					StringTools.ternary(uploadConfig.getCdnHost(), host), fileId, path, uploadConfig.getData(),
					clientFileName));
		}
		return info;
	}

	private String getFileId(String identity, String clientFileName, UploadConfig tokenConfig) {
		return StringTools.ternary(tokenConfig.getPrefix())
				+ IdTools.encode(identity + StringTools.RandomString.random(10))
				+ StringTools.ternary(tokenConfig.getSuffix());
	}

	private String getCallbackBody(String callbackBody, String host, String fileId, String savePath, String data,
			String clientFileName) throws UnsupportedEncodingException {
		// 拼接host
		if (StringTools.isNotEmptyAndBlank(host)) {
			callbackBody += "&host=" + host;
		}
		callbackBody += "&fileId=" + fileId + "&path=" + URLEncoder.encode(savePath, "UTF-8") + "&fileName="
				+ URLEncoder.encode(clientFileName, "UTF-8");
		callbackBody += "&mimeType=${mimeType}&imageInfo.format=${imageInfo.format}&imgHeight=${imageInfo.height}&imgWidth=${imageInfo.width}";
		callbackBody += "&data=" + StringTools.ternary(data);
		return callbackBody;
	}

//	public static void main(String[] args) throws Throwable {
//		String bucket = "image-1301722750";
//		QcloudConfig config = QcloudConfig.of("AKIDkF4fYaBNdleMRGu42mHWAbnhKgofCVW9",
//				"UhceQu60enfxzkEhw83g271kHYaLo0uz", bucket);
//		PresignedUrlTools.getInstance(config).genPresignedUrl(identity, clientFileName, uploadConfig);
//		genPresignedUrl
//	}
}