package com.jz.oss.jar.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.oss.Tables;
import com.jz.jooq.oss.tables.pojos.SmsVerificationCode;
import com.jz.jooq.oss.tables.records.SmsVerificationCodeRecord;

@Lazy
@Repository
public class SmsVerificationCodeRepository extends OssBaseRepository {

	private static final com.jz.jooq.oss.tables.SmsVerificationCode SVC = Tables.SMS_VERIFICATION_CODE;

	public void save(SmsVerificationCodeRecord record) {
		ossCtx.insertInto(SVC).set(record).execute();
	}

	public SmsVerificationCode getCode(String phone, long timeMillis) {
		List<SmsVerificationCode> codes = ossCtx.selectFrom(SVC)
				.where(SVC.PHONE.eq(phone).and(SVC.EXPIRY.ge(timeMillis))).orderBy(SVC.CREATE_TIME.desc())
				.fetchInto(SmsVerificationCode.class);
		return ArrayMapTools.isNotEmpty(codes) ? codes.get(0) : null;
	}

	public boolean checkCode(String phone, String code, long timeMillis) {
		return ossCtx.fetchExists(SVC, SVC.PHONE.eq(phone).and(SVC.EXPIRY.ge(timeMillis)).and(SVC.CODE.eq(code)));
	}
	
	public int countExpiry(String phone, long timeMillis) {
		return ossCtx.fetchCount(SVC, SVC.PHONE.eq(phone).and(SVC.EXPIRY.ge(timeMillis)));
	}
}
