/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.repository.OAUserRepository;
import com.jz.jar.oa.repository.UserPositionHistoryRepository;
import com.jz.jar.oa.repository.UserTrainingRepository;
import com.jz.jar.oa.repository.UserWelfareRepository;
import com.jz.jooq.oa.tables.pojos.User;
import com.jz.jooq.oa.tables.pojos.UserPositionHistory;
import com.jz.jooq.oa.tables.pojos.UserTraining;
import com.jz.jooq.oa.tables.pojos.UserWelfare;
import com.jz.jooq.oa.tables.records.UserPositionHistoryRecord;
import com.jz.jooq.oa.tables.records.UserRecord;
import com.jz.jooq.oa.tables.records.UserTrainingRecord;
import com.jz.jooq.oa.tables.records.UserWelfareRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class OAUserService {
    @Autowired
    private OAUserRepository userRepository;
    @Autowired
    private UserWelfareRepository userWelfareRepository;
    @Autowired
    private UserTrainingRepository userTrainingRepository;
    @Autowired
    private UserPositionHistoryRepository userPositionHistoryRepository;

    public void updateUserStatus(String uid, int status) {
        Preconditions.checkArgument((status == 1 || status == 2 ? 1 : 0) != 0, (Object)"status\u53c2\u6570\u9519\u8bef");
        this.userRepository.updateUserStatus(uid, status);
    }

    public User getUser(String uid) {
        return this.userRepository.getUser(uid);
    }

    public User getUserInfo(String uid) {
        return this.userRepository.getUserInfo(uid);
    }

    public Map<String, User> mutiGetUserMap(Collection<String> uids) {
        List<User> list = this.userRepository.mutGetUsers(uids);
        if (ArrayMapTools.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
    }

    public Map<String, User> mutGetAllUsers(Collection<String> uids) {
        List<User> list = this.userRepository.mutGetAllUsers(uids);
        if (ArrayMapTools.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
    }

    public Map<String, Integer> getStaffNumByDeptIds(Set<String> deptIds) {
        return this.userRepository.getStaffNumByDeptIds(deptIds);
    }

    public int cntUsers(String uid, Integer status, String departmentId, String companyId, String workAddrId, String keyword, Collection<String> filterDeptIds, String minJoinDate, String maxJoinDate) {
        return this.userRepository.cntUsers(uid, status, departmentId, companyId, workAddrId, keyword, filterDeptIds, minJoinDate, maxJoinDate);
    }

    public List<User> filterUsersByConditionsLimit(String uid, Integer status, String departmentId, String companyId, String workAddrId, String keyword, Collection<String> filterDeptIds, String minJoinDate, String maxJoinDate, int start, int size) {
        return this.userRepository.filterUsersByConditionsLimit(uid, status, departmentId, companyId, workAddrId, keyword, filterDeptIds, minJoinDate, maxJoinDate, start, size);
    }

    public List<String> filterUids(String keyword) {
        return this.userRepository.filterUids(keyword);
    }

    public void createUser(UserRecord record) {
        this.userRepository.createUser(record);
    }

    public void updateUser(String fuid, String chineseName, String englishName, String phone, int status, String cardType, String cardBak, String nationality, String country, String fertility, String residenceType, String residenceAddress, String contactAddress, String landline, String emergencyContact, String emergencyPhone, Integer insurance, Integer childFree, Integer trainAgreement, String joinDate, Integer isDirect, int attendanceId, String childs) {
        this.userRepository.updateUser(fuid, chineseName, englishName, phone, status, cardType, cardBak, nationality, country, fertility, residenceType, residenceAddress, contactAddress, landline, emergencyContact, emergencyPhone, insurance, childFree, trainAgreement, joinDate, isDirect, attendanceId, childs);
    }

    public void updateUserPositionInfo(String fuid, String joinChannel, String referrer, String officialJoinDate, String contractStart, String contractEnd, String contractType, String contractNature, String deptId, String positionId, String superiorId, String relations, String workAddrId, String companyId, String laborUnion, String costCenter, String trailStart, String trailEnd, String resignationDate, String resignationWay, String internStart, String internEnd, String positionStart, String positionEnd) {
        this.userRepository.updateUserPositionInfo(fuid, joinChannel, referrer, officialJoinDate, contractStart, contractEnd, contractType, contractNature, deptId, positionId, superiorId, relations, workAddrId, companyId, laborUnion, costCenter, trailStart, trailEnd, resignationDate, resignationWay, internStart, internEnd, positionStart, positionEnd);
    }

    public void updateBackgroundSurvey(String fuid, String backgroundSurvey) {
        this.userRepository.updateBackgroundSurvey(fuid, backgroundSurvey);
    }

    public void updateUserAccountInfo(String fuid, String bankAccount, String bank, String bankArea, String fund, String socialSecurityType, String socialSecurityArea, String tax, Integer annualLeaveDays, String certificate, Integer oldLeaveDays, String leaveAdjustDate, Integer calAttendance) {
        this.userRepository.updateUserAccountInfo(fuid, bankAccount, bank, bankArea, fund, socialSecurityType, socialSecurityArea, tax, annualLeaveDays, certificate, oldLeaveDays, leaveAdjustDate, calAttendance);
    }

    public void updateUserWelfare(String fuid, List<UserWelfareRecord> welfareRecords) {
        this.userWelfareRepository.updateUserWelfare(fuid, welfareRecords);
    }

    public void updateUserTraining(String fuid, List<UserTrainingRecord> trainingRecords) {
        this.userTrainingRepository.updateUserTraining(fuid, trainingRecords);
    }

    public void updateUserPositionHistory(String fuid, List<UserPositionHistoryRecord> positionRecords) {
        this.userPositionHistoryRepository.updateUserPositionHistory(fuid, positionRecords);
    }

    public List<UserWelfare> getUserWelfares(String fuid) {
        return this.userWelfareRepository.getUserWelfares(fuid);
    }

    public Map<String, List<UserWelfare>> mutiGetUserWelfares(Collection<String> fuids) {
        HashMap map = Maps.newHashMap();
        List<UserWelfare> userWelfares = this.userWelfareRepository.mutiGetUserWelfares(fuids);
        if (ArrayMapTools.isEmpty(userWelfares)) {
            return map;
        }
        for (UserWelfare w : userWelfares) {
            if (map.containsKey(w.getUid())) {
                ((List)map.get(w.getUid())).add(w);
                continue;
            }
            map.put(w.getUid(), Lists.newArrayList((Object[])new UserWelfare[]{w}));
        }
        return map;
    }

    public List<UserTraining> getUserTrainings(String fuid) {
        return this.userTrainingRepository.getUserTrainings(fuid);
    }

    public List<UserPositionHistory> getUserPositionHistorys(String fuid) {
        return this.userPositionHistoryRepository.getUserPositionHistorys(fuid);
    }

    public void backInOffice(String fuid, String joinDate, String officialJoinDate, String contractStart, String contractEnd, String contractType, String contractNature) {
        this.userRepository.backInOffice(fuid, joinDate, officialJoinDate, contractStart, contractEnd, contractType, contractNature);
    }

    public void createUserTraining(String fuid, String name, String type, Long startTime, Long endTime, int status, String remark, String certificate) {
        List<UserTraining> userTrainings = this.userTrainingRepository.getUserTrainings(fuid);
        this.userTrainingRepository.createUserTraining(fuid, userTrainings.size() + 1, name, type, startTime, endTime, status, remark, certificate);
    }

    public Integer getOldLeaveDays(String fuid) {
        return this.userRepository.getOldLeaveDays(fuid);
    }

    public List<String> filterUidsByConditionsLimit(String uid, String companyId, String keyword, int start, int size) {
        return this.userRepository.filterUidsByConditionsLimit(uid, companyId, keyword, start, size);
    }

    public List<UserTraining> mutiGetUserTrainings(Collection<String> uids) {
        return this.userTrainingRepository.mutiGetUserTrainings(uids);
    }

    public int getMaxAttendanceId() {
        return this.userRepository.getMaxAttendanceId();
    }

    public List<String> getExistPhones(Collection<String> phones) {
        return this.userRepository.getExistPhones(phones);
    }

    public List<User> filterSimpleUsers(String uid, Integer status, String departmentId, String companyId, String workAddrId, String keyword, List<String> filterDeptIds, String minJoinDate, String maxJoinDate) {
        return this.userRepository.filterSimpleUsers(uid, status, departmentId, companyId, workAddrId, keyword, filterDeptIds, minJoinDate, maxJoinDate);
    }

    public void updateUserBackInfo(String fuid, int haveTeacherCert, String teacherCert) {
        this.userRepository.updateUserBackInfo(fuid, haveTeacherCert, teacherCert);
    }
}

