package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserWorkflowInfo;
import com.jz.jooq.oa.tables.records.UserWorkflowInfoRecord;

@Lazy
@Repository
public class UserWorkflowInfoRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserWorkflowInfo UWFI = Tables.USER_WORKFLOW_INFO;
	private static final com.jz.jooq.oa.tables.UserWorkflowHandler H = Tables.USER_WORKFLOW_HANDLER;

	public void addOrUpdateUserWorkflowInfo(String identify, String uid, String wfid, String companyId,
			String workAddrId, String title, String reason, String handler, Integer nextStep, String remarks,
			UserWorkflow workflowStatus) {
		long timeMillis = System.currentTimeMillis();
		UserWorkflowInfoRecord workflowInfoRecord = new UserWorkflowInfoRecord();
		workflowInfoRecord.setId(identify);
		workflowInfoRecord.setUid(uid);
		workflowInfoRecord.setWfid(wfid);
		workflowInfoRecord.setCompanyId(companyId);
		workflowInfoRecord.setWorkAddrId(workAddrId);
		workflowInfoRecord.setTitle(title);
		workflowInfoRecord.setReason(reason);
		workflowInfoRecord.setHandler(handler);
		workflowInfoRecord.setNextStep(nextStep);
		workflowInfoRecord.setStatus(workflowStatus.getCode());
		workflowInfoRecord.setResult(null);
		workflowInfoRecord.setRemarks(remarks);
		workflowInfoRecord.setCreateTime(timeMillis);
		workflowInfoRecord.setLastUpdate(timeMillis);
		oaCtx.insertInto(UWFI).set(workflowInfoRecord).onDuplicateKeyUpdate().set(workflowInfoRecord).execute();
	}

	public Condition getWhereCondition(Collection<String> uwfids, String keyword, Long startTime, Long endTime,
			String nickname, String companyId, Collection<String> nickUwfids, Integer flowCode) {
		Condition condition = UWFI.ID.in(uwfids);
		if (StringUtils.isNotEmpty(keyword)) {
			condition = condition.and(DSL.or(UWFI.TITLE.like("%" + keyword + "%"), UWFI.ID.like("%" + keyword + "%")));
		}
		if (startTime != null && endTime != null) {
			condition = condition.and(UWFI.CREATE_TIME.between(startTime, endTime));
		}
		if (flowCode != null) {
			if (flowCode == 99) {
				condition = condition
						.and(UWFI.STATUS.in(UserWorkflow.INFO_ING.getCode(), UserWorkflow.INFO_FINISHED.getCode()));
			} else {
				condition = condition.and(UWFI.STATUS.eq(flowCode));
			}
		}
		if (StringUtils.isNotEmpty(nickname) && ArrayMapTools.isNotEmpty(nickUwfids)) {
			condition = condition.and(UWFI.ID.in(nickUwfids));
		}
		if (StringUtils.isNotEmpty(companyId)) {
			condition = condition.and(UWFI.COMPANY_ID.eq(companyId));
		}
		return condition;
	}

	public int cntWorkflows(List<String> uwfids, String keyword, Long startTime, Long endTime, String nickname,
			String companyId, Collection<String> nickUwfids, Integer flowCode) {
		return oaCtx.fetchCount(UWFI,
				getWhereCondition(uwfids, keyword, startTime, endTime, nickname, companyId, nickUwfids, flowCode));
	}

	public List<UserWorkflowInfo> mutiGetUserWorkflowInfos(Collection<String> uwfids, String keyword, Long startTime,
			Long endTime, String nickname, String companyId, Collection<String> nickUwfids, int start, int size,
			Integer flowCode, String uid, int code) {
		Table<?> table = UWFI;
		Condition condition = getWhereCondition(uwfids, keyword, startTime, endTime, nickname, companyId, nickUwfids,
				flowCode);
		SortField<?> sf = UWFI.CREATE_TIME.desc();
		if (code == 3 && StringUtils.isNotEmpty(uid)) {
			table = UWFI.join(H).on(UWFI.ID.eq(H.UWFID));
			condition = condition.and(H.UID.eq(uid).and(H.RESULT.isNotNull()));
			sf = H.LAST_UPDATE.desc();
		}

		return oaCtx.select(UWFI.fields()).from(table).where(condition).groupBy(UWFI.ID).orderBy(sf).limit(start, size)
				.fetchInto(UserWorkflowInfo.class);
	}

	public UserWorkflowInfo getUserWorkflowInfo(String id) {
		return oaCtx.selectFrom(UWFI).where(UWFI.ID.eq(id)).fetchAnyInto(UserWorkflowInfo.class);
	}

	public void updateHandleInfo(String id, String handler, Integer step, UserWorkflow status, UserWorkflow result) {
		UpdateSetMoreStep<UserWorkflowInfoRecord> moreStep = oaCtx.update(UWFI).set(UWFI.HANDLER, handler)
				.set(UWFI.NEXT_STEP, step).set(UWFI.LAST_UPDATE, System.currentTimeMillis());
		if (null != status)
			moreStep = moreStep.set(UWFI.STATUS, status.getCode());
		if (null != result)
			moreStep = moreStep.set(UWFI.RESULT, result.getCode());
		moreStep.where(UWFI.ID.eq(id)).execute();
	}

	public Map<String, Integer> getStatusMap(String uid) {
		List<Map<String, Object>> maps = oaCtx.select(UWFI.STATUS.as("status"), DSL.count().as("cnt")).from(UWFI)
				.where(UWFI.UID.eq(uid)).groupBy(UWFI.STATUS).fetchMaps();
		Map<String, Integer> rsMap = Maps.newHashMap();
		if (ArrayMapTools.isNotEmpty(maps)) {
			Integer all = 0;
			for (Map<String, Object> it : maps) {
				if (MapUtils.getString(it, "status").equals("1")) {
					all += MapUtils.getInteger(it, "cnt");
					rsMap.put("going", MapUtils.getInteger(it, "cnt"));
				} else if (MapUtils.getString(it, "status").equals("2")) {
					all += MapUtils.getInteger(it, "cnt");
					rsMap.put("end", MapUtils.getInteger(it, "cnt"));
				} else {
					all += MapUtils.getInteger(it, "cnt");
				}
			}
			rsMap.put("all", all);
		}
		return rsMap;
	}

	/** 获取指定流程最新的通过流程id */
	public String getLatestPassedWorkflowId(String uid, String wfid) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.UID.eq(uid).and(UWFI.WFID.eq(wfid)).and(UWFI.RESULT.eq(UserWorkflow.RESULT_PASS.getCode()))
						.and(UWFI.STATUS.eq(UserWorkflow.INFO_FINISHED.getCode())))
				.orderBy(UWFI.LAST_UPDATE.desc()).fetchAnyInto(String.class);
	}

	/** 获取某用户指定流程审核通过的流程ids */
	public List<String> mutiGetUserWorkflowId(String uid, String wfid, String keyword) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.UID.eq(uid).and(UWFI.WFID.eq(wfid)).and(UWFI.RESULT.eq(UserWorkflow.RESULT_PASS.getCode()))
						.and(UWFI.STATUS.eq(UserWorkflow.INFO_FINISHED.getCode()))
						.and(StringUtils.isEmpty(keyword) ? DSL.trueCondition() : UWFI.ID.like("%" + keyword + "%")))
				.limit(50).fetchInto(String.class);
	}

	/** 获取某用户指定流程审核通过的流程ids */
	public List<String> mutiGetUserWorkflowIds(String uid, Collection<String> wfids, String keyword) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.UID.eq(uid).and(UWFI.WFID.in(wfids)).and(UWFI.RESULT.eq(UserWorkflow.RESULT_PASS.getCode()))
						.and(UWFI.STATUS.eq(UserWorkflow.INFO_FINISHED.getCode()))
						.and(StringUtils.isEmpty(keyword) ? DSL.trueCondition() : UWFI.ID.like("%" + keyword + "%")))
				.limit(50).fetchInto(String.class);
	}

	/** 获取所有采购+补货流程审核通过的流程ids */
	public List<String> mutiGetAllLogisticsFWorkflowIds(String uid, Collection<String> wfids, String keyword) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.WFID.in(wfids).and(UWFI.RESULT.eq(UserWorkflow.RESULT_PASS.getCode()))
						.and(UWFI.STATUS.eq(UserWorkflow.INFO_FINISHED.getCode()))
						.and(StringUtils.isEmpty(keyword) ? DSL.trueCondition() : UWFI.ID.like("%" + keyword + "%")))
				.limit(50).fetchInto(String.class);
	}

	/** 获取某用户指定流程审核通过的流程s */
	public List<UserWorkflowInfo> mutiGetUserWorkflows(String uid, String name) {
		return oaCtx.selectFrom(UWFI)
				.where(UWFI.UID.eq(uid).and(UWFI.WFID.eq(name)).and(UWFI.RESULT.eq(UserWorkflow.RESULT_PASS.getCode()))
						.and(UWFI.STATUS.eq(UserWorkflow.INFO_FINISHED.getCode())))
				.fetchInto(UserWorkflowInfo.class);
	}

	public List<String> getUserLeaveWorkflowInProgress(String uid, String workflowKey) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.UID.eq(uid)
						.and(UWFI.WFID.eq(workflowKey).and(UWFI.STATUS.eq(UserWorkflow.INFO_ING.getCode()))))
				.fetchInto(String.class);
	}

	public void updateBackModifyToNormal(String uwfid, String remarks) {
		Integer _null = null;
		oaCtx.update(UWFI).set(UWFI.RESULT, _null).set(UWFI.REMARKS, remarks)
				.set(UWFI.LAST_UPDATE, System.currentTimeMillis()).where(UWFI.ID.eq(uwfid)).execute();
	}

	/** 获取所有审核通过的个人资产申报流程ids */
	public List<String> mutiGetAllAssetReportIds(String uid, String name) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.WFID.eq(name).and(UWFI.RESULT.eq(UserWorkflow.RESULT_PASS.getCode()))
						.and(UWFI.STATUS.eq(UserWorkflow.INFO_FINISHED.getCode())))
				.fetchInto(String.class);
	}

	public List<UserWorkflowInfo> mutiGetUserWorkflowInfos(Collection<String> uwfids) {
		return oaCtx.selectFrom(UWFI).where(UWFI.ID.in(uwfids)).fetchInto(UserWorkflowInfo.class);
	}

	public List<String> getUwfidsInProgressNeedUid(Collection<String> uwfidsNeedUid) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.ID.in(uwfidsNeedUid).and(UWFI.STATUS.eq(UserWorkflow.INFO_ING.getCode())))
				.fetchInto(String.class);
	}

	public void updateHandler(Collection<String> uwfids, String uid, String taker) {
		oaCtx.update(UWFI).set(UWFI.HANDLER, taker).where(UWFI.ID.in(uwfids).and(UWFI.HANDLER.eq(uid))).execute();
	}

	public List<String> getUwfidsByWfid(Collection<String> wfids) {
		return oaCtx.select(UWFI.ID).from(UWFI).where(purchaseCondition(wfids)).fetchInto(String.class);
	}

	public List<String> filterPurchaseUwfids(String uwfid, Collection<String> wfids) {
		return oaCtx.select(UWFI.ID).from(UWFI).where(purchaseCondition(wfids).and(UWFI.ID.like("%" + uwfid + "%")))
				.fetchInto(String.class);
	}

	// 取出所有wfid流程的流水号id 不包括未发起的以及手动结束的
	private Condition purchaseCondition(Collection<String> wfids) {
		Condition condition = UWFI.WFID.in(wfids);
		condition = condition.and(UWFI.STATUS.ne(UserWorkflow.INFO_WAIT.getCode())
				.and(UWFI.STATUS.eq(UserWorkflow.INFO_FINISHED.getCode()).and(UWFI.RESULT.isNotNull())));
		return condition;
	}

	public int cntCreatedByMe(String uid, String keyword, Long startTime, Long endTime,
			Collection<String> nicknameUwfids, String companyId, Integer flowType) {
		return oaCtx.fetchCount(UWFI,
				getCreatedByMeConditon(uid, keyword, startTime, endTime, nicknameUwfids, companyId, flowType));
	}

	private Condition getCreatedByMeConditon(String uid, String keyword, Long startTime, Long endTime,
			Collection<String> nicknameUwfids, String companyId, Integer flowCode) {
		Condition condition = UWFI.UID.eq(uid);
		if (StringUtils.isNotEmpty(keyword)) {
			condition = condition.and(DSL.or(UWFI.TITLE.like("%" + keyword + "%"), UWFI.ID.like("%" + keyword + "%")));
		}
		if (startTime != null && endTime != null) {
			condition = condition.and(UWFI.CREATE_TIME.between(startTime, endTime));
		}
		if (flowCode != null) {
			condition = condition.and(UWFI.STATUS.eq(flowCode));
		}
		if (nicknameUwfids != null) {
			condition = condition.and(UWFI.ID.in(nicknameUwfids));
		}
		if (StringUtils.isNotEmpty(companyId)) {
			condition = condition.and(UWFI.COMPANY_ID.eq(companyId));
		}
		return condition;
	}

	public List<UserWorkflowInfo> mutiGetCreatedByMe(String uid, String keyword, Long startTime, Long endTime,
			Collection<String> nicknameUwfids, String companyId, Integer flowType, int start, int size) {
		return oaCtx.selectFrom(UWFI)
				.where(getCreatedByMeConditon(uid, keyword, startTime, endTime, nicknameUwfids, companyId, flowType))
				.orderBy(UWFI.CREATE_TIME.desc()).limit(start, size).fetchInto(UserWorkflowInfo.class);
	}

	public int cntWaitedForMe(String keyword, Long startTime, Long endTime, String companyId,
			Collection<String> uwfids) {
		return oaCtx.fetchCount(UWFI, getWaitedForMeCondition(keyword, startTime, endTime, uwfids, companyId));
	}

	private Condition getWaitedForMeCondition(String keyword, Long startTime, Long endTime, Collection<String> uwfids,
			String companyId) {
		Condition condition = UWFI.ID.in(uwfids);
		if (StringUtils.isNotEmpty(keyword)) {
			condition = condition.and(DSL.or(UWFI.TITLE.like("%" + keyword + "%"), UWFI.ID.like("%" + keyword + "%")));
		}
		if (startTime != null && endTime != null) {
			condition = condition.and(UWFI.CREATE_TIME.between(startTime, endTime));
		}
		if (StringUtils.isNotEmpty(companyId)) {
			condition = condition.and(UWFI.COMPANY_ID.eq(companyId));
		}
		return condition;
	}

	public List<UserWorkflowInfo> mutiGetWaitedForMe(String keyword, Long startTime, Long endTime, String companyId,
			Collection<String> uwfids, int start, int size) {
		return oaCtx.selectFrom(UWFI).where(getWaitedForMeCondition(keyword, startTime, endTime, uwfids, companyId))
				.orderBy(UWFI.CREATE_TIME.desc()).limit(start, size).fetchInto(UserWorkflowInfo.class);
	}

	public Condition getProcessedByMeCondition(Collection<String> uwfids, String keyword, Long startTime, Long endTime,
			String companyId, Integer flowType) {
		Condition condition = UWFI.ID.in(uwfids);
		if (StringUtils.isNotEmpty(keyword)) {
			condition = condition.and(DSL.or(UWFI.TITLE.like("%" + keyword + "%"), UWFI.ID.like("%" + keyword + "%")));
		}
		if (startTime != null && endTime != null) {
			condition = condition.and(UWFI.CREATE_TIME.between(startTime, endTime));
		}
		if (StringUtils.isNotEmpty(companyId)) {
			condition = condition.and(UWFI.COMPANY_ID.eq(companyId));
		}
		if (flowType != null) {
			condition = condition.and(UWFI.STATUS.eq(flowType));
		}
		return condition;
	}

	public int cntProcessedByMe(Collection<String> uwfids, String keyword, Long startTime, Long endTime,
			String companyId, Integer flowType) {
		return oaCtx.fetchCount(UWFI,
				getProcessedByMeCondition(uwfids, keyword, startTime, endTime, companyId, flowType));
	}

	public List<UserWorkflowInfo> mutiGetProcessedByMe(Collection<String> uwfids, String keyword, Long startTime,
			Long endTime, String companyId, Integer flowType, int start, int size) {
		return oaCtx.selectFrom(UWFI)
				.where(getProcessedByMeCondition(uwfids, keyword, startTime, endTime, companyId, flowType))
				.orderBy(UWFI.CREATE_TIME.desc()).limit(start, size).fetchInto(UserWorkflowInfo.class);
	}

	public int cntCopiedToMe(Collection<String> uwfids, String keyword, Long startTime, Long endTime,
			String companyId) {
		return oaCtx.fetchCount(UWFI, getCopiedToMeCondition(uwfids, keyword, startTime, endTime, companyId));
	}

	private Condition getCopiedToMeCondition(Collection<String> uwfids, String keyword, Long startTime, Long endTime,
			String companyId) {
		Condition condition = UWFI.ID.in(uwfids);
		if (StringUtils.isNotEmpty(keyword)) {
			condition = condition.and(DSL.or(UWFI.TITLE.like("%" + keyword + "%"), UWFI.ID.like("%" + keyword + "%")));
		}
		if (startTime != null && endTime != null) {
			condition = condition.and(UWFI.CREATE_TIME.between(startTime, endTime));
		}
		if (StringUtils.isNotEmpty(companyId)) {
			condition = condition.and(UWFI.COMPANY_ID.eq(companyId));
		}
		return condition;
	}

	public List<UserWorkflowInfo> mutiGetCopiedToMe(Collection<String> uwfids, String keyword, Long startTime,
			Long endTime, String companyId, int start, int size) {
		return oaCtx.selectFrom(UWFI).where(getCopiedToMeCondition(uwfids, keyword, startTime, endTime, companyId))
				.orderBy(UWFI.CREATE_TIME.desc()).limit(start, size).fetchInto(UserWorkflowInfo.class);
	}

}
