package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.Department;

@Lazy
@Repository
public class OADepartmentRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.Department D = Tables.DEPARTMENT;

	public List<Department> getAllDepartment() {
		return oaCtx.selectFrom(D).where(D.ENABLE.eq(1)).orderBy(D.LEVEL.asc(), D.CREATE_TIME.asc())
				.fetchInto(Department.class);
	}

	public List<Department> mutiGetDepartment(Collection<String> deptIds) {
		return oaCtx.selectFrom(D).where(D.ID.in(deptIds)).fetchInto(Department.class);
	}

	public List<Department> multiGetSimpleDepartment(Collection<String> deptIds) {
		return oaCtx.select(D.ID, D.NAME).from(D).where(D.ID.in(deptIds)).fetchInto(Department.class);
	}

	public Department getDepartment(String deptId) {
		return oaCtx.selectFrom(D).where(D.ID.eq(deptId)).fetchAnyInto(Department.class);
	}

}
