/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.Department;
import com.jz.jooq.oa.tables.records.DepartmentRecord;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class OADepartmentRepository
extends OABaseRepository {
    private static final Department D = Tables.DEPARTMENT;

    public List<com.jz.jooq.oa.tables.pojos.Department> getAllDepartment() {
        return this.oaCtx.selectFrom((Table)D).where(new Condition[]{OADepartmentRepository.D.ENABLE.eq((Object)1)}).orderBy(OADepartmentRepository.D.LEVEL.asc(), OADepartmentRepository.D.CREATE_TIME.asc()).fetchInto(com.jz.jooq.oa.tables.pojos.Department.class);
    }

    public List<com.jz.jooq.oa.tables.pojos.Department> mutiGetDepartment(Collection<String> deptIds) {
        return this.oaCtx.selectFrom((Table)D).where(new Condition[]{OADepartmentRepository.D.ID.in(deptIds)}).fetchInto(com.jz.jooq.oa.tables.pojos.Department.class);
    }

    public List<com.jz.jooq.oa.tables.pojos.Department> multiGetSimpleDepartment(Collection<String> deptIds) {
        return this.oaCtx.select((SelectField)OADepartmentRepository.D.ID, (SelectField)OADepartmentRepository.D.NAME).from((TableLike)D).where(new Condition[]{OADepartmentRepository.D.ID.in(deptIds)}).fetchInto(com.jz.jooq.oa.tables.pojos.Department.class);
    }

    public com.jz.jooq.oa.tables.pojos.Department getDepartment(String deptId) {
        return (com.jz.jooq.oa.tables.pojos.Department)this.oaCtx.selectFrom((Table)D).where(new Condition[]{OADepartmentRepository.D.ID.eq((Object)deptId)}).fetchAnyInto(com.jz.jooq.oa.tables.pojos.Department.class);
    }

    public boolean checkExist(String id) {
        return this.oaCtx.fetchExists((Table)D, OADepartmentRepository.D.ID.eq((Object)id));
    }

    public boolean checkExist(String parentId, String name) {
        return this.oaCtx.fetchExists((Table)D, OADepartmentRepository.D.NAME.eq((Object)name).and(StringUtils.isEmpty((CharSequence)parentId) ? OADepartmentRepository.D.LEVEL.eq((Object)1) : OADepartmentRepository.D.LEVEL.eq((Object)2).and(OADepartmentRepository.D.PARENT_ID.eq((Object)parentId))));
    }

    public void createDepartment(String id, String name, String parentId, Integer level, String leaderId) {
        this.oaCtx.insertInto((Table)D).set((Record)new DepartmentRecord(id, name, parentId, level, leaderId, Long.valueOf(System.currentTimeMillis()), null, Integer.valueOf(1))).execute();
    }

    public void updateDepartment(String deptId, String parentId, String name, String leaderId) {
        DepartmentRecord record = new DepartmentRecord();
        record.setParentId(parentId);
        record.setName(name);
        record.setLeader(leaderId);
        this.oaCtx.update((Table)D).set((Record)record).where(new Condition[]{OADepartmentRepository.D.ID.eq((Object)deptId)}).execute();
    }

    public void deleteDepartment(String deptId) {
        this.oaCtx.update((Table)D).set((Field)OADepartmentRepository.D.ENABLE, (Object)0).where(new Condition[]{OADepartmentRepository.D.ID.eq((Object)deptId)}).execute();
    }

    public void updateLeader(String currentlyLeader, String newleader) {
        this.oaCtx.update((Table)D).set((Field)OADepartmentRepository.D.LEADER, (Object)newleader).where(new Condition[]{OADepartmentRepository.D.LEADER.eq((Object)currentlyLeader)}).execute();
    }

    public boolean checkExistChildren(String deptId) {
        return this.oaCtx.fetchExists((Table)D, OADepartmentRepository.D.PARENT_ID.eq((Object)deptId));
    }
}

