package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.Department;
import com.jz.jooq.oa.tables.records.DepartmentRecord;

@Lazy
@Repository
public class OADepartmentRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.Department D = Tables.DEPARTMENT;

	public List<Department> getAllDepartment() {
		return oaCtx.selectFrom(D).orderBy(D.LEVEL.asc(), D.CREATE_TIME.asc()).fetchInto(Department.class);
	}

	public List<Department> mutiGetDepartment(Collection<String> deptIds) {
		return oaCtx.selectFrom(D).where(D.ID.in(deptIds)).fetchInto(Department.class);
	}

	public List<Department> multiGetSimpleDepartment(Collection<String> deptIds) {
		return oaCtx.select(D.ID, D.NAME).from(D).where(D.ID.in(deptIds)).fetchInto(Department.class);
	}

	public Department getDepartment(String deptId) {
		return oaCtx.selectFrom(D).where(D.ID.eq(deptId)).fetchAnyInto(Department.class);
	}

	public boolean checkExist(String id) {
		return oaCtx.fetchExists(D, D.ID.eq(id));
	}

	public boolean checkExist(String parentId, String name) {
		return oaCtx.fetchExists(D, D.NAME.eq(name)
				.and(StringUtils.isEmpty(parentId) ? D.LEVEL.eq(1) : D.LEVEL.eq(2).and(D.PARENT_ID.eq(parentId))));
	}

	public void createDepartment(String id, String name, String parentId, Integer level, String leaderId) {
		oaCtx.insertInto(D)
				.set(new DepartmentRecord(id, name, parentId, level, leaderId, System.currentTimeMillis(), null))
				.execute();
	}

	public void updateDepartment(String deptId, String parentId, String name, String leaderId) {
		DepartmentRecord record = new DepartmentRecord();
		record.setParentId(parentId);
		record.setName(name);
		record.setLeader(leaderId);
		oaCtx.update(D).set(record).where(D.ID.eq(deptId)).execute();
	}

	public void deleteDepartment(String deptId) {
		oaCtx.deleteFrom(D).where(D.ID.eq(deptId)).execute();
	}

	public void updateLeader(String currentlyLeader, String newleader) {
		oaCtx.update(D).set(D.LEADER, newleader).where(D.LEADER.eq(currentlyLeader)).execute();
	}

	public boolean checkExistChildren(String deptId) {
		return oaCtx.fetchExists(D, D.PARENT_ID.eq(deptId));
	}

}
