/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.repository.OADepartmentRepository;
import com.jz.jar.oa.repository.OAPositionRepository;
import com.jz.jar.oa.service.OAUserService;
import com.jz.jar.oa.wrapper.DepartmentWrapper;
import com.jz.jar.oa.wrapper.OAUserWrapper;
import com.jz.jar.oa.wrapper.PositionWrapper;
import com.jz.jooq.oa.tables.pojos.Department;
import com.jz.jooq.oa.tables.pojos.Position;
import com.jz.jooq.oa.tables.pojos.User;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class OADepartmentService {
    @Autowired
    private OADepartmentRepository departmentRepository;
    @Autowired
    private OAPositionRepository positionRepository;
    @Autowired
    private OAUserService oaUserService;

    public Collection<DepartmentWrapper> getAllDepartmentWithPosition() {
        DepartmentWrapper wrapper;
        List<Position> positions = this.positionRepository.getAllPosition();
        HashMap parent2PosMap = Maps.newHashMap();
        positions.forEach(p -> {
            if (parent2PosMap.containsKey(p.getDeptId())) {
                ((List)parent2PosMap.get(p.getDeptId())).add(PositionWrapper.of(p));
            } else {
                parent2PosMap.put(p.getDeptId(), Lists.newArrayList((Object[])new PositionWrapper[]{PositionWrapper.of(p)}));
            }
        });
        List<Department> departments = this.departmentRepository.getAllDepartment();
        LinkedHashMap lv1DeparmentMap = Maps.newLinkedHashMap();
        LinkedHashMap lv2DeparmentMap = Maps.newLinkedHashMap();
        HashSet uids = Sets.newHashSet();
        HashSet deptIds = Sets.newHashSet();
        Map<Object, Object> leadersMap = Maps.newHashMap();
        Map<Object, Object> deptStaff = Maps.newHashMap();
        if (ArrayMapTools.isNotEmpty(departments)) {
            departments.forEach(it -> {
                uids.add(it.getLeader());
                deptIds.add(it.getId());
            });
        }
        leadersMap = this.oaUserService.mutiGetUserMap(uids);
        deptStaff = this.oaUserService.getStaffNumByDeptIds(deptIds);
        for (Department d : departments) {
            wrapper = DepartmentWrapper.of(d);
            if (leadersMap.containsKey(d.getLeader())) {
                OAUserWrapper leader = OAUserWrapper.ofSimple((User)leadersMap.get(d.getLeader()));
                wrapper.setLeader(leader);
            }
            if (deptStaff.containsKey(d.getId())) {
                wrapper.setStaffNum((Integer)deptStaff.get(d.getId()));
            } else {
                wrapper.setStaffNum(0);
            }
            wrapper.setPositions((List)parent2PosMap.get(d.getId()));
            if (d.getLevel() == 2) {
                lv2DeparmentMap.put(d.getId(), wrapper);
                continue;
            }
            if (d.getLevel() != 3 || !lv2DeparmentMap.containsKey(d.getParentId())) continue;
            ((DepartmentWrapper)lv2DeparmentMap.get(d.getParentId())).addChild(wrapper);
            int lv3 = wrapper.getStaffNum();
            int lv2 = ((DepartmentWrapper)lv2DeparmentMap.get(d.getParentId())).getStaffNum();
            ((DepartmentWrapper)lv2DeparmentMap.get(d.getParentId())).setStaffNum(lv2 + lv3);
        }
        for (Department d : departments) {
            wrapper = DepartmentWrapper.of(d);
            if (leadersMap.containsKey(d.getLeader())) {
                OAUserWrapper leader = OAUserWrapper.ofSimple((User)leadersMap.get(d.getLeader()));
                wrapper.setLeader(leader);
            }
            if (deptStaff.containsKey(d.getId())) {
                wrapper.setStaffNum((Integer)deptStaff.get(d.getId()));
            } else {
                wrapper.setStaffNum(0);
            }
            wrapper.setPositions((List)parent2PosMap.get(d.getId()));
            if (d.getLevel() == 1) {
                lv1DeparmentMap.put(d.getId(), wrapper);
                continue;
            }
            if (!lv1DeparmentMap.containsKey(d.getParentId())) continue;
            ((DepartmentWrapper)lv1DeparmentMap.get(d.getParentId())).addChild((DepartmentWrapper)lv2DeparmentMap.get(d.getId()));
            int lv2 = ((DepartmentWrapper)lv2DeparmentMap.get(d.getId())).getStaffNum();
            int lv1 = ((DepartmentWrapper)lv1DeparmentMap.get(d.getParentId())).getStaffNum();
            ((DepartmentWrapper)lv1DeparmentMap.get(d.getParentId())).setStaffNum(lv2 + lv1);
        }
        return lv1DeparmentMap.values();
    }

    public Collection<DepartmentWrapper> getAllDepartmentSimple() {
        DepartmentWrapper wrapper;
        List<Department> departments = this.departmentRepository.getAllDepartment();
        LinkedHashMap lv1DeparmentMap = Maps.newLinkedHashMap();
        LinkedHashMap lv2DeparmentMap = Maps.newLinkedHashMap();
        HashSet deptIds = Sets.newHashSet();
        if (ArrayMapTools.isNotEmpty(departments)) {
            departments.forEach(it -> deptIds.add(it.getId()));
        }
        for (Department d : departments) {
            wrapper = DepartmentWrapper.ofSimple(d);
            if (d.getLevel() == 2) {
                lv2DeparmentMap.put(d.getId(), wrapper);
                continue;
            }
            if (d.getLevel() != 3 || !lv2DeparmentMap.containsKey(d.getParentId())) continue;
            ((DepartmentWrapper)lv2DeparmentMap.get(d.getParentId())).addChild(wrapper);
        }
        for (Department d : departments) {
            wrapper = DepartmentWrapper.ofSimple(d);
            if (d.getLevel() == 1) {
                lv1DeparmentMap.put(d.getId(), wrapper);
                continue;
            }
            if (!lv1DeparmentMap.containsKey(d.getParentId())) continue;
            ((DepartmentWrapper)lv1DeparmentMap.get(d.getParentId())).addChild((DepartmentWrapper)lv2DeparmentMap.get(d.getId()));
        }
        return lv1DeparmentMap.values();
    }

    public Map<String, DepartmentWrapper> mutiGetDepartmentWithParentName(Collection<String> deptIds) {
        List<Department> currentDepartments = this.departmentRepository.mutiGetDepartment(deptIds);
        Set<String> parentIds = currentDepartments.stream().filter(it -> StringUtils.isNotEmpty((CharSequence)it.getParentId())).map(it -> it.getParentId()).collect(Collectors.toSet());
        HashMap parentNameMap = Maps.newHashMap();
        HashSet rootIds = Sets.newHashSet();
        List<Object> parents = Lists.newArrayList();
        if (ArrayMapTools.isNotEmpty(parentIds)) {
            parents = this.departmentRepository.mutiGetDepartment(parentIds);
            parents.forEach(it -> {
                parentNameMap.put(it.getId(), it.getName());
                rootIds.add(it.getParentId());
            });
        }
        HashMap parent2root = Maps.newHashMap();
        if (ArrayMapTools.isNotEmpty((Collection)rootIds)) {
            List<Department> roots = this.departmentRepository.mutiGetDepartment(rootIds);
            for (Department department : parents) {
                roots.forEach(it -> {
                    if (StringUtils.equals((CharSequence)d.getParentId(), (CharSequence)it.getId())) {
                        parent2root.put(d.getId(), it);
                    }
                });
            }
        }
        HashMap rsMap = Maps.newHashMap();
        for (Department department : currentDepartments) {
            DepartmentWrapper wrapper = DepartmentWrapper.of(department);
            if (StringUtils.isNotEmpty((CharSequence)department.getParentId())) {
                wrapper.setParentId(department.getParentId());
                wrapper.setParentName((String)parentNameMap.get(department.getParentId()));
                if (parent2root.containsKey(department.getParentId())) {
                    wrapper.setRootId(((Department)parent2root.get(department.getParentId())).getId());
                    wrapper.setRootName(((Department)parent2root.get(department.getParentId())).getName());
                }
            }
            rsMap.put(department.getId(), wrapper);
        }
        return rsMap;
    }

    public DepartmentWrapper getDepartmentWrapperWithParentName(String deptId) {
        Department parent;
        Department d = this.departmentRepository.getDepartment(deptId);
        if (d == null) {
            return null;
        }
        DepartmentWrapper wrapper = DepartmentWrapper.of(d);
        if (StringUtils.isNotEmpty((CharSequence)d.getParentId()) && (parent = this.departmentRepository.getDepartment(d.getParentId())) != null) {
            wrapper.setParentId(parent.getId());
            wrapper.setParentName(parent.getName());
            if (StringUtils.isNotEmpty((CharSequence)parent.getParentId())) {
                Department root = this.departmentRepository.getDepartment(parent.getParentId());
                wrapper.setRootId(root.getId());
                wrapper.setRootName(root.getName());
            }
        }
        return wrapper;
    }

    public List<Department> multiGetSimpleDepartment(Collection<String> deptIds) {
        return this.departmentRepository.multiGetSimpleDepartment(deptIds);
    }

    public Map<String, Department> multiGetSimpleDepartmentHas(Collection<String> deptIds) {
        List<Department> departments = this.multiGetSimpleDepartment(deptIds);
        if (ArrayMapTools.isEmpty(departments)) {
            return Maps.newHashMap();
        }
        return departments.stream().collect(Collectors.toMap(it -> it.getId(), it -> it));
    }

    public boolean checkExist(String id) {
        return this.departmentRepository.checkExist(id);
    }

    public boolean checkExist(String parentId, String name) {
        return this.departmentRepository.checkExist(parentId, name);
    }

    public Department getDepartment(String deptId) {
        return this.departmentRepository.getDepartment(deptId);
    }

    public void createDepartment(String id, String name, String parentId, Integer level, String leaderId) {
        this.departmentRepository.createDepartment(id, name, parentId, level, leaderId);
    }

    public void updateDepartment(String deptId, String parentId, String name, String leaderId) {
        this.departmentRepository.updateDepartment(deptId, parentId, name, leaderId);
    }

    public void deleteDepartment(String deptId) {
        this.departmentRepository.deleteDepartment(deptId);
    }

    public void updateLeader(String currentlyLeader, String newleader) {
        this.departmentRepository.updateLeader(currentlyLeader, newleader);
    }

    public boolean checkExistChildren(String deptId) {
        return this.departmentRepository.checkExistChildren(deptId);
    }
}

