package com.jz.jar.oa.repository;

import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserWorkflowAttachment;
import com.jz.jooq.oa.tables.records.UserWorkflowAttachmentRecord;

@Lazy
@Repository
public class UserWorkflowAttachmentRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserWorkflowAttachment UWA = Tables.USER_WORKFLOW_ATTACHMENT;

	public void addUserWorkflowAttachment(String uwfid, Map<String, String> attachmentName2Path) {
		List<UserWorkflowAttachmentRecord> attachmentRecords = Lists.newArrayList();
		attachmentName2Path.forEach((name, url) -> {
			attachmentRecords.add(new UserWorkflowAttachmentRecord(null, uwfid, name, url));
		});
		oaCtx.batchInsert(attachmentRecords).execute();
	}

	public List<UserWorkflowAttachment> mutiGetAttachments(String uwfid) {
		return oaCtx.select(UWA.NAME, UWA.URL).from(UWA).where(UWA.UWFID.eq(uwfid))
				.fetchInto(UserWorkflowAttachment.class);
	}

	public void cleanAttachments(String uwfid) {
		oaCtx.deleteFrom(UWA).where(UWA.UWFID.eq(uwfid)).execute();
	}
}
