/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.cache;

import com.jz.common.utils.datetime.TimeTools;
import com.jz.common.utils.text.StringTools;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Component
public class WorkflowIdentifyCache {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowIdentifyCache.class);
    private static final int seconds = 86400;
    @Autowired
    private JedisCluster jedisCluster;

    private String getTempKey() {
        String today = TimeTools.getDateTime((long)Calendar.getInstance().getTimeInMillis(), (String)"yyyyMMdd");
        return new StringBuffer("workflow:identity:").append(today).toString();
    }

    public String getWorkflowIdentity() {
        try {
            String tempKey = this.getTempKey();
            Long incr = this.jedisCluster.incr(tempKey);
            this.jedisCluster.expire(tempKey, 86400);
            return incr.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return StringTools.RandomString.numbers((int)7);
        }
    }
}

