package com.jz.jar.oa.repository;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserVacationLeft;
import com.jz.jooq.oa.tables.records.UserVacationLeftRecord;

@Lazy
@Repository
public class UserVacationLeftRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserVacationLeft L = Tables.USER_VACATION_LEFT;

	public UserVacationLeft getUserVacationLeft(String uid) {
		return oaCtx.selectFrom(L).where(L.UID.eq(uid)).fetchAnyInto(UserVacationLeft.class);
	}

	public List<UserVacationLeft> getUserVacationLeft(Collection<String> filterUids) {
		return oaCtx.selectFrom(L).where(L.UID.in(filterUids)).fetchInto(UserVacationLeft.class);
	}

	public void createUserVacationLeft(String uid, BigDecimal overtimeDay) {
		oaCtx.insertInto(L).set(new UserVacationLeftRecord(uid, new BigDecimal(0), new BigDecimal(0), overtimeDay,
				new BigDecimal(0), System.currentTimeMillis())).execute();
	}

	public void updateVacationLeft(String uid, double fixedAnnualVacation, double compensatedLeave) {
		UserVacationLeftRecord record = new UserVacationLeftRecord();
		record.setUid(uid);
		record.setFixedAnnualVacation(new BigDecimal(fixedAnnualVacation));
//		record.setFloatAnnualVacation(new BigDecimal(floatAnnualVacation));
		record.setCompensatedLeave(new BigDecimal(compensatedLeave));
//		record.setPaidSickLeave(new BigDecimal(paidSickLeave));
		record.setLastUpdated(System.currentTimeMillis());
		oaCtx.insertInto(L).set(record).onDuplicateKeyUpdate().set(record).execute();

	}

	public void addFixedAnnualVacation(String uid, double leaveDay) {
		oaCtx.update(L).set(L.FIXED_ANNUAL_VACATION, L.FIXED_ANNUAL_VACATION.add(leaveDay))
				.set(L.LAST_UPDATED, System.currentTimeMillis()).where(L.UID.eq(uid)).execute();
	}

	public void addFloatAnnualVacation(String uid, double leaveDay) {
		oaCtx.update(L).set(L.FLOAT_ANNUAL_VACATION, L.FLOAT_ANNUAL_VACATION.add(leaveDay))
				.set(L.LAST_UPDATED, System.currentTimeMillis()).where(L.UID.eq(uid)).execute();
	}

	public void addCompensatedLeave(String uid, double leaveDay) {
		oaCtx.update(L).set(L.COMPENSATED_LEAVE, L.COMPENSATED_LEAVE.add(leaveDay))
				.set(L.LAST_UPDATED, System.currentTimeMillis()).where(L.UID.eq(uid)).execute();
	}

	public void addPaidSickLeave(String uid, double leaveDay) {
		oaCtx.update(L).set(L.PAID_SICK_LEAVE, L.PAID_SICK_LEAVE.add(leaveDay))
				.set(L.LAST_UPDATED, System.currentTimeMillis()).where(L.UID.eq(uid)).execute();
	}
}
