package com.jz.jar.oa.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserTraining;
import com.jz.jooq.oa.tables.records.UserTrainingRecord;

@Lazy
@Repository
public class UserTrainingRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserTraining T = Tables.USER_TRAINING;

	public void updateUserTraining(String fuid, List<UserTrainingRecord> trainingRecords) {
		oaCtx.deleteFrom(T).where(T.UID.eq(fuid)).execute();
		oaCtx.batchInsert(trainingRecords).execute();
	}

	public List<UserTraining> getUserTrainings(String fuid) {
		return oaCtx.selectFrom(T).where(T.UID.eq(fuid)).orderBy(T.IDX.desc()).fetchInto(UserTraining.class);
	}

	public void createUserTraining(String fuid, int idx, String name, String type, Long startTime, Long endTime,
			int status, String remark, String certificate) {
		UserTrainingRecord record = new UserTrainingRecord();
		record.setUid(fuid);
		record.setIdx(idx);
		record.setName(name);
		record.setType(type);
		record.setStartTime(startTime);
		record.setEndTime(endTime);
		record.setStatus(status);
		record.setRemark(remark);
		record.setCertificate(certificate);
		record.setLastUpdated(System.currentTimeMillis());
		oaCtx.insertInto(T).set(record).execute();
	}

}
