package com.jz.jar.oa.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.WorkflowSetting;

@Lazy
@Repository
public class WorkflowSettingRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.WorkflowSetting WS = Tables.WORKFLOW_SETTING;

	public List<WorkflowSetting> getWorkflowSetting(String wfid) {
		return oaCtx.selectFrom(WS).where(WS.WFID.eq(wfid)).orderBy(WS.STEP.asc()).fetchInto(WorkflowSetting.class);
	}

}
