package com.jz.jar.oa.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.repository.OACompanyRepository;
import com.jz.jooq.oa.tables.pojos.Company;

@Lazy
@Service
public class OACompanyService {

	@Autowired
	private OACompanyRepository companyRepository;

	public List<Company> getAllCompany() {
		return companyRepository.getAllCompany();
	}

	public List<Company> getAllCompanySimple() {
		return companyRepository.getAllCompanySimple();
	}

	public List<Company> multiGetCompanies(Collection<String> companyIds) {
		return companyRepository.multiGetCompanies(companyIds);
	}

	public Map<String, Company> mutiGetCompanyMap(Collection<String> companyIds) {
		List<Company> list = companyRepository.mutiGetCompanys(companyIds);
		if (ArrayMapTools.isEmpty(list))
			return Maps.newHashMap();
		return list.stream().collect(Collectors.toMap(it -> it.getId(), it -> it));
	}

	public Map<String, Company> multiGetSimpleCompanies(Collection<String> companyIds) {
		List<Company> list = companyRepository.multiGetSimpleCompanies(companyIds);
		if (ArrayMapTools.isEmpty(list))
			return Maps.newHashMap();
		return list.stream().collect(Collectors.toMap(it -> it.getId(), it -> it));
	}

	public Company getCompany(String companyId) {
		return companyRepository.getCompany(companyId);
	}

	public boolean checkName(String name) {
		return companyRepository.checkName(name);
	}

	public boolean checkExist(String id) {
		return companyRepository.checkExist(id);
	}

	public void createCompany(String id, String name, String license, String accounter, String cashier,
			String assetsKeeperIT, String assetsKeeperWork, String law) {
		companyRepository.createCompany(id, name, license, accounter, cashier, assetsKeeperIT, assetsKeeperWork, law);
	}

	public void updateCompany(String id, String name, String license, String accounter, String cashier,
			String assetsKeeperIT, String assetsKeeperWork, String law) {
		companyRepository.updateCompany(id, name, license, accounter, cashier, assetsKeeperIT, assetsKeeperWork, law);
	}

	public void deleteCompany(String id) {
		companyRepository.deleteCompany(id);
	}

	public List<Company> getCompanyForAssetsManager(String assetsKeeper) {
		return companyRepository.getCompanyForAssetsManager(assetsKeeper);
	}

	public List<String> getCompanyIdForAssetsManager(String assetsKeeper) {
		return companyRepository.getCompanyIdForAssetsManager(assetsKeeper);
	}

	public boolean isAssetManager(String companyId, String uid, boolean isIt) {
		return companyRepository.isAssetManager(companyId, uid, isIt);
	}

	public void updateAssetsKeeper(String currentlyKeeper, String newKeeper) {
		companyRepository.updateAssetsKeeper(currentlyKeeper, newKeeper);
	}

	public void updateAccounter(String currentlyAccounter, String newAccounter) {
		companyRepository.updateAccounter(currentlyAccounter, newAccounter);
	}

	public void updateCashier(String currentlyCashier, String newCashier) {
		companyRepository.updateCashier(currentlyCashier, newCashier);
	}

	public void updateLaw(String currentlyLaw, String newLaw) {
		companyRepository.updateLaw(currentlyLaw, newLaw);
	}

	public List<String> getCompanyIdForAccounter(String accounter) {
		return companyRepository.getCompanyIdForAccounter(accounter);
	}

	public List<Company> getFilteredCompany(String name) {
		return companyRepository.getFilteredCompany(name);
	}

	public boolean isAssetsKeeper(String uid) {
		return companyRepository.isAssetsKeeper(uid);
	}

	public List<String> filterUidCompanyIds(String uid) {
		return companyRepository.filterUidCompanyIds(uid);
	}
}
