package com.jz.jar.oa.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jar.oa.finals.OAFinial;
import com.jz.jar.oa.repository.UserWorkflowInfoRepository;
import com.jz.jar.oa.repository.UserWorkflowListRepository;
import com.jz.jooq.oa.tables.pojos.UserWorkflowInfo;

@Lazy
@Service
public class UserWorkflowInfoService {

	@Autowired
	private UserWorkflowInfoRepository userWorkflowInfoRepository;
	@Autowired
	private UserWorkflowListRepository userWorkflowListRepository;

	public void addOrUpdateUserWorkflowInfo(String identify, String uid, String wfid, String companyId,
			String workAddrId, String title, String reason, String handler, Integer nextStep, String remarks,
			UserWorkflow workflowStatus) {
		userWorkflowInfoRepository.addOrUpdateUserWorkflowInfo(identify, uid, wfid, companyId, workAddrId, title,
				reason, handler, nextStep, remarks, workflowStatus);
	}

	public List<UserWorkflowInfo> mutiGetUserWorkflowInfos(Collection<String> uwfids, String keyword, Long startTime,
			Long endTime, String nickname, Collection<String> nickUwfids, int start, int size, Integer flowCode) {
		return userWorkflowInfoRepository.mutiGetUserWorkflowInfos(uwfids, keyword, startTime, endTime, nickname,
				nickUwfids, start, size, flowCode);
	}

	public UserWorkflowInfo getUserWorkflowInfo(String id) {
		return userWorkflowInfoRepository.getUserWorkflowInfo(id);
	}

	public int cntWorkflows(List<String> uwfids, String keyword, Long startTime, Long endTime, String nickname,
			Collection<String> nickUwfids, Integer flowCode) {
		return userWorkflowInfoRepository.cntWorkflows(uwfids, keyword, startTime, endTime, nickname, nickUwfids,
				flowCode);
	}

	public void updateHandleInfo(String id, String handler, Integer step, UserWorkflow status, UserWorkflow result) {
		userWorkflowInfoRepository.updateHandleInfo(id, handler, step, status, result);
	}

	public Map<String, Integer> getStatusMap(String uid) {
		return userWorkflowInfoRepository.getStatusMap(uid);
	}

	/** 获取指定流程最新的通过流程id */
	public String getLatestPassedWorkflowId(String uid, String wfid) {
		return userWorkflowInfoRepository.getLatestPassedWorkflowId(uid, wfid);
	}

	public List<String> getUserWorkflowInProgress(String uid, String workflowKey) {
		return userWorkflowInfoRepository.getUserLeaveWorkflowInProgress(uid, workflowKey);
	}

	public void updateBackModifyToNormal(String uwfid, String remarks) {
		userWorkflowInfoRepository.updateBackModifyToNormal(uwfid, remarks);
	}

	public int cntUserWorkflowWaitedForMe(String uid) {
		int code = UserWorkflow.LIST_PENDING.getCode();
		List<String> uwfids = userWorkflowListRepository.getUserWorkflows(uid, code);
		return this.cntWorkflows(uwfids, null, null, null, null, null, OAFinial.FLOWTYPE);
	}

	public List<UserWorkflowInfo> mutiGetUserWorkflowInfos(Collection<String> uwfids) {
		return userWorkflowInfoRepository.mutiGetUserWorkflowInfos(uwfids);
	}

	public List<String> getUwfidsInProgressNeedUid(List<String> uwfidsNeedUid) {
		return userWorkflowInfoRepository.getUwfidsInProgressNeedUid(uwfidsNeedUid);
	}

	public void updateHandler(List<String> uwfids, String uid, String taker) {
		userWorkflowInfoRepository.updateHandler(uwfids, uid, taker);
	}

}
