package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserWorkflowInfo;
import com.jz.jooq.oa.tables.records.UserWorkflowInfoRecord;

@Lazy
@Repository
public class UserWorkflowInfoRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserWorkflowInfo UWFI = Tables.USER_WORKFLOW_INFO;

	public void addOrUpdateUserWorkflowInfo(String identify, String uid, String wfid, String companyId,
			String workAddrId, String title, String reason, String handler, Integer nextStep, String remarks,
			UserWorkflow workflowStatus) {
		long timeMillis = System.currentTimeMillis();
		UserWorkflowInfoRecord workflowInfoRecord = new UserWorkflowInfoRecord();
		workflowInfoRecord.setId(identify);
		workflowInfoRecord.setUid(uid);
		workflowInfoRecord.setWfid(wfid);
		workflowInfoRecord.setCompanyId(companyId);
		workflowInfoRecord.setWorkAddrId(workAddrId);
		workflowInfoRecord.setTitle(title);
		workflowInfoRecord.setReason(reason);
		workflowInfoRecord.setHandler(handler);
		workflowInfoRecord.setNextStep(nextStep);
		workflowInfoRecord.setStatus(workflowStatus.getCode());
		workflowInfoRecord.setResult(null);
		workflowInfoRecord.setRemarks(remarks);
		workflowInfoRecord.setCreateTime(timeMillis);
		workflowInfoRecord.setLastUpdate(timeMillis);
		oaCtx.insertInto(UWFI).set(workflowInfoRecord).onDuplicateKeyUpdate().set(workflowInfoRecord).execute();
	}

	public Condition getWhereCondition(Collection<String> uwfids, String keyword, Long startTime, Long endTime,
			String nickname, Collection<String> nickUwfids, Integer flowCode) {
		Condition condition = UWFI.ID.in(uwfids);
		if (StringUtils.isNotEmpty(keyword)) {
			condition = condition.and(DSL.or(UWFI.TITLE.like("%" + keyword + "%"), UWFI.ID.like("%" + keyword + "%")));
		}
		if (startTime != null && endTime != null) {
			condition = condition.and(UWFI.CREATE_TIME.between(startTime, endTime));
		}
		if (flowCode != null) {
			if (flowCode == 99) {
				condition = condition
						.and(UWFI.STATUS.in(UserWorkflow.INFO_ING.getCode(), UserWorkflow.INFO_FINISHED.getCode()));
			} else {
				condition = condition.and(UWFI.STATUS.eq(flowCode));
			}
		}
		if (StringUtils.isNotEmpty(nickname) && ArrayMapTools.isNotEmpty(nickUwfids)) {
			condition = condition.and(UWFI.ID.in(nickUwfids));
		}
		return condition;
	}

	public int cntWorkflows(List<String> uwfids, String keyword, Long startTime, Long endTime, String nickname,
			Collection<String> nickUwfids, Integer flowCode) {
		return oaCtx.fetchCount(UWFI,
				getWhereCondition(uwfids, keyword, startTime, endTime, nickname, nickUwfids, flowCode));
	}

	public List<UserWorkflowInfo> mutiGetUserWorkflowInfos(Collection<String> uwfids, String keyword, Long startTime,
			Long endTime, String nickname, Collection<String> nickUwfids, int start, int size, Integer flowCode) {
		return oaCtx.selectFrom(UWFI)
				.where(getWhereCondition(uwfids, keyword, startTime, endTime, nickname, nickUwfids, flowCode))
				.orderBy(UWFI.ID.desc()).limit(start, size).fetchInto(UserWorkflowInfo.class);
	}

	public UserWorkflowInfo getUserWorkflowInfo(String id) {
		return oaCtx.selectFrom(UWFI).where(UWFI.ID.eq(id)).fetchAnyInto(UserWorkflowInfo.class);
	}

	public void updateHandleInfo(String id, String handler, Integer step, UserWorkflow status, UserWorkflow result) {
		UpdateSetMoreStep<UserWorkflowInfoRecord> moreStep = oaCtx.update(UWFI).set(UWFI.HANDLER, handler)
				.set(UWFI.NEXT_STEP, step).set(UWFI.LAST_UPDATE, System.currentTimeMillis());
		if (null != status)
			moreStep = moreStep.set(UWFI.STATUS, status.getCode());
		if (null != result)
			moreStep = moreStep.set(UWFI.RESULT, result.getCode());
		moreStep.where(UWFI.ID.eq(id)).execute();
	}

	public Map<String, Integer> getStatusMap(String uid) {
		List<Map<String, Object>> maps = oaCtx.select(UWFI.STATUS.as("status"), DSL.count().as("cnt")).from(UWFI)
				.where(UWFI.UID.eq(uid)).groupBy(UWFI.STATUS).fetchMaps();
		Map<String, Integer> rsMap = Maps.newHashMap();
		if (ArrayMapTools.isNotEmpty(maps)) {
			Integer all = 0;
			for (Map<String, Object> it : maps) {
				if (MapUtils.getString(it, "status").equals("1")) {
					all += MapUtils.getInteger(it, "cnt");
					rsMap.put("going", MapUtils.getInteger(it, "cnt"));
				} else if (MapUtils.getString(it, "status").equals("2")) {
					all += MapUtils.getInteger(it, "cnt");
					rsMap.put("end", MapUtils.getInteger(it, "cnt"));
				} else {
					all += MapUtils.getInteger(it, "cnt");
				}
			}
			rsMap.put("all", all);
		}
		return rsMap;
	}

	/** 获取指定流程最新的通过流程id */
	public String getLatestPassedWorkflowId(String uid, String wfid) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.UID.eq(uid).and(UWFI.WFID.eq(wfid)).and(UWFI.RESULT.eq(UserWorkflow.RESULT_PASS.getCode()))
						.and(UWFI.STATUS.eq(UserWorkflow.INFO_FINISHED.getCode())))
				.orderBy(UWFI.LAST_UPDATE.desc()).fetchAnyInto(String.class);
	}

	/** 获取某用户指定流程审核通过的流程ids */
	public List<String> mutiGetUserWorkflowIds(String uid, String name) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.UID.eq(uid).and(UWFI.WFID.eq(name)).and(UWFI.RESULT.eq(UserWorkflow.RESULT_PASS.getCode()))
						.and(UWFI.STATUS.eq(UserWorkflow.INFO_FINISHED.getCode())))
				.fetchInto(String.class);
	}

	/** 获取某用户指定流程审核通过的流程s */
	public List<UserWorkflowInfo> mutiGetUserWorkflows(String uid, String name) {
		return oaCtx.selectFrom(UWFI)
				.where(UWFI.UID.eq(uid).and(UWFI.WFID.eq(name)).and(UWFI.RESULT.eq(UserWorkflow.RESULT_PASS.getCode()))
						.and(UWFI.STATUS.eq(UserWorkflow.INFO_FINISHED.getCode())))
				.fetchInto(UserWorkflowInfo.class);
	}

	public List<String> getUserLeaveWorkflowInProgress(String uid, String workflowKey) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.UID.eq(uid)
						.and(UWFI.WFID.eq(workflowKey).and(UWFI.STATUS.eq(UserWorkflow.INFO_ING.getCode()))))
				.fetchInto(String.class);
	}

	public void updateBackModifyToNormal(String uwfid, String remarks) {
		Integer _null = null;
		oaCtx.update(UWFI).set(UWFI.RESULT, _null).set(UWFI.REMARKS, remarks)
				.set(UWFI.LAST_UPDATE, System.currentTimeMillis()).where(UWFI.ID.eq(uwfid)).execute();
	}

	/** 获取所有审核通过的个人资产申报流程ids */
	public List<String> mutiGetAllAssetReportIds(String uid, String name) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.WFID.eq(name).and(UWFI.RESULT.eq(UserWorkflow.RESULT_PASS.getCode()))
						.and(UWFI.STATUS.eq(UserWorkflow.INFO_FINISHED.getCode())))
				.fetchInto(String.class);
	}

	public List<UserWorkflowInfo> mutiGetUserWorkflowInfos(Collection<String> uwfids) {
		return oaCtx.selectFrom(UWFI).where(UWFI.ID.in(uwfids)).fetchInto(UserWorkflowInfo.class);
	}

	public List<String> getUwfidsInProgressNeedUid(List<String> uwfidsNeedUid) {
		return oaCtx.select(UWFI.ID).from(UWFI)
				.where(UWFI.ID.in(uwfidsNeedUid).and(UWFI.STATUS.eq(UserWorkflow.INFO_ING.getCode())))
				.fetchInto(String.class);
	}

	public void updateHandler(List<String> uwfids, String uid, String taker) {
		oaCtx.update(UWFI).set(UWFI.HANDLER, taker).where(UWFI.ID.in(uwfids).and(UWFI.HANDLER.eq(uid))).execute();
	}

}
