package com.jz.jar.oa.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.repository.OAUserRepository;
import com.jz.jooq.oa.tables.pojos.User;

@Lazy
@Service
public class OAUserService {

	@Autowired
	private OAUserRepository userRepository;

	public void insUpdateUser(String uid, String chineseName, String englishName, String phone, String companyId,
			String workAddrId, String deptId, String positionId, String superiorId, String joinDate, String relations,
			Integer insurance, Integer childFree, Integer trainAgreement, Integer annualLeaveDays, String certificate) {
		userRepository.insUpdateUser(uid, chineseName, englishName, phone, companyId, workAddrId, deptId, positionId,
				superiorId, joinDate, relations, insurance, childFree, trainAgreement, annualLeaveDays, certificate);
	}

	public void updateUserStatus(String uid, int status) {
		Preconditions.checkArgument(status == 1 || status == 2, "status参数错误");
		userRepository.updateUserStatus(uid, status);
	}

	public User getUser(String uid) {
		return userRepository.getUser(uid);
	}

	public User getUserInfo(String uid) {
		return userRepository.getUserInfo(uid);
	}

	public Map<String, User> mutiGetUserMap(Collection<String> uids) {
		List<User> list = userRepository.mutGetUsers(uids);
		if (ArrayMapTools.isEmpty(list))
			return Maps.newHashMap();
		return list.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
	}

	public Map<String, User> mutGetAllUsers(Collection<String> uids) {
		List<User> list = userRepository.mutGetAllUsers(uids);
		if (ArrayMapTools.isEmpty(list))
			return Maps.newHashMap();
		return list.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
	}

	public Map<String, User> multiGetSimpleUser(Collection<String> uids) {
		List<User> users = userRepository.multiGetSimpleUser(uids);
		if (ArrayMapTools.isEmpty(users))
			return Maps.newHashMap();
		return users.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
	}

	public Map<String, User> multiGetAllSimpleUser(Collection<String> uids) {
		List<User> users = userRepository.multiGetAllSimpleUser(uids);
		if (ArrayMapTools.isEmpty(users))
			return Maps.newHashMap();
		return users.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
	}

	public User getSimpleUser(String uid) {
		return userRepository.getSimpleUser(uid);
	}

	public Map<String, Integer> getStaffNumByCompanyIds(Set<String> companyIds) {
		return userRepository.getStaffNumByCompanyIds(companyIds);
	}

	public boolean isIncumbency(String uid) {
		return userRepository.isIncumbency(uid);
	}

	public int cntCompanyUser(String id) {
		return userRepository.cntCompanyUser(id);
	}

	public int cntDeptUser(String deptId) {
		return userRepository.cntDeptUser(deptId);
	}

	public int cntPositionUser(String id) {
		return userRepository.cntPositionUser(id);
	}

	public Map<String, Integer> getStaffNumByWorkAddressIds(Set<String> workAddressIds) {
		return userRepository.getStaffNumByWorkAddressIds(workAddressIds);
	}

	public int cntWorkAddressUser(String id) {
		return userRepository.cntWorkAddressUser(id);
	}

	public int cntAllWorkAddressUser(String workAddrId) {
		return userRepository.cntAllWorkAddressUser(workAddrId);
	}

	public Map<String, Integer> getStaffNumByDeptIds(Set<String> deptIds) {
		return userRepository.getStaffNumByDeptIds(deptIds);
	}

	public void updateUserPosition(String id) {
		userRepository.updateUserPosition(id);
	}

	public void updateUserCompany(String id) {
		userRepository.updateUserCompany(id);
	}

	public void updateUserDept(String deptId) {
		userRepository.updateUserDept(deptId);
	}

	public List<User> getUserInfoPage(String companyId, String keyword, int start, int size) {
		return userRepository.getUserInfoPage(companyId, keyword, start, size);
	}

	public User getUserByPosition(String positionId) {
		return userRepository.getUserByPosition(positionId);
	}

	/** 当前公司下存在在职员工的所有部门Id */
	public List<String> getDeptIdsForCompany(String companyId) {
		return userRepository.getDeptIdsForCompany(companyId);
	}

	/** 当前部门下所有的在职员工 */
	public List<User> getUsersForDepartment(String companyId, String deptId) {
		return userRepository.getUsersForDepartment(companyId, deptId);
	}

	public User getUserByPhone(String phone) {
		return userRepository.getUserByPhone(phone);
	}

	public String getSuperiorUid(String uid) {
		return userRepository.getSuperiorUid(uid);
	}

	public void updateSuperior(String currentlySuperior, String newSuperior) {
		userRepository.updateSuperior(currentlySuperior, newSuperior);
	}

	public List<User> getUsersForWorkAddress(String workAddrId, int start, int size) {
		return userRepository.getUsersForWorkAddress(workAddrId, start, size);
	}

	public List<String> filterUidsByConditionsLimit(String uid, String departmentId, String companyId,
			String workAddrId, String keyword, Collection<String> filterWorkAddrIds,
			Collection<String> filterCompanyIds, int start, int size) {
		return userRepository.filterUidsByConditionsLimit(uid, departmentId, companyId, workAddrId, keyword,
				filterWorkAddrIds, filterCompanyIds, start, size);
	}

	public int cntUsersByConditions(String uid, String departmentId, String companyId, String workAddrId,
			String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds) {
		return userRepository.cntUsersByConditions(uid, departmentId, companyId, workAddrId, keyword, filterWorkAddrIds,
				filterCompanyIds);
	}

	public int cntUsers(String uid, int status, String departmentId, String companyId, String workAddrId,
			String keyword) {
		return userRepository.cntUsers(uid, status, departmentId, companyId, workAddrId, keyword);
	}

	public List<User> filterUsersByConditionsLimit(String uid, int status, String departmentId, String companyId,
			String workAddrId, String keyword, int start, int size) {
		return userRepository.filterUsersByConditionsLimit(uid, status, departmentId, companyId, workAddrId, keyword,
				start, size);
	}

	public List<User> getHrList(List<String> hrs) {
		return userRepository.getHrList(hrs);
	}

	public List<String> findUserIdForWorkAddress(Collection<String> workAddressIds) {
		return userRepository.findUserIdForWorkAddress(workAddressIds);
	}

	public List<String> getCompanyForUser(Collection<String> uids) {
		return userRepository.getCompanyForUser(uids);
	}

	public void changeToResignation(String uid, int status, String resignationDate) {
		userRepository.changeToResignation(uid, status, resignationDate);
	}

}
