/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.google.common.collect.Lists;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.UserWorkflowList;
import com.jz.jooq.oa.tables.records.UserWorkflowListRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserWorkflowListRepository
extends OABaseRepository {
    private static final UserWorkflowList UWFL = Tables.USER_WORKFLOW_LIST;

    private UserWorkflowListRecord makeRecord(String identify, String uid, UserWorkflow type, long timeMillis) {
        UserWorkflowListRecord record = new UserWorkflowListRecord();
        record.setUid(uid);
        record.setUwfid(identify);
        record.setType(Integer.valueOf(type.getCode()));
        record.setLastUpdate(Long.valueOf(timeMillis));
        return record;
    }

    public void addUserWorkflowList(String identify, String launch, String pendingHandler, Collection<String> carbonCopies) {
        long timeMillis = System.currentTimeMillis();
        ArrayList listRecords = Lists.newArrayList();
        if (StringTools.isNotEmptyAndBlank((String)launch)) {
            listRecords.add(this.makeRecord(identify, launch, UserWorkflow.LIST_LAUNCH, timeMillis));
        }
        if (StringTools.isNotEmptyAndBlank((String)pendingHandler)) {
            listRecords.add(this.makeRecord(identify, pendingHandler, UserWorkflow.LIST_PENDING, timeMillis));
        }
        for (String carbonCopy : carbonCopies) {
            listRecords.add(this.makeRecord(identify, carbonCopy, UserWorkflow.LIST_CARBON_COPY, timeMillis));
        }
        this.oaCtx.batchInsert((Collection)listRecords).execute();
    }

    public List<String> getUserWorkflows(String uid, int code) {
        return this.oaCtx.select((SelectField)UserWorkflowListRepository.UWFL.UWFID).from((TableLike)UWFL).where(new Condition[]{UserWorkflowListRepository.UWFL.UID.eq((Object)uid).and(UserWorkflowListRepository.UWFL.TYPE.eq((Object)code))}).fetchInto(String.class);
    }

    public void addPendingList(String identify, String handler) {
        long timeMillis = System.currentTimeMillis();
        this.oaCtx.insertInto((Table)UWFL).set((Record)this.makeRecord(identify, handler, UserWorkflow.LIST_PENDING, timeMillis)).onDuplicateKeyUpdate().set((Field)UserWorkflowListRepository.UWFL.TYPE, (Object)UserWorkflow.LIST_PENDING.getCode()).set((Field)UserWorkflowListRepository.UWFL.LAST_UPDATE, (Object)timeMillis).execute();
    }

    public void updateType(String uid, String identify, UserWorkflow type) {
        UserWorkflowListRecord record = new UserWorkflowListRecord();
        record.setType(Integer.valueOf(type.getCode()));
        record.setLastUpdate(Long.valueOf(System.currentTimeMillis()));
        this.oaCtx.update((Table)UWFL).set((Record)record).where(new Condition[]{UserWorkflowListRepository.UWFL.UID.eq((Object)uid).and(UserWorkflowListRepository.UWFL.UWFID.eq((Object)identify))}).execute();
    }

    public List<String> getContainsList(String identify, Collection<String> uids) {
        return this.oaCtx.select((SelectField)UserWorkflowListRepository.UWFL.UID).from((TableLike)UWFL).where(new Condition[]{UserWorkflowListRepository.UWFL.UID.in(uids).and(UserWorkflowListRepository.UWFL.UWFID.eq((Object)identify))}).fetchInto(String.class);
    }

    public void addCarbonCopyList(String identify, Collection<String> ccs) {
        long timeMillis = System.currentTimeMillis();
        ArrayList listRecords = Lists.newArrayList();
        for (String carbonCopy : ccs) {
            listRecords.add(this.makeRecord(identify, carbonCopy, UserWorkflow.LIST_CARBON_COPY, timeMillis));
        }
        this.oaCtx.batchInsert((Collection)listRecords).execute();
    }

    public boolean isContains(String uid, String identify) {
        return this.oaCtx.fetchExists((Table)UWFL, UserWorkflowListRepository.UWFL.UID.eq((Object)uid).and(UserWorkflowListRepository.UWFL.UWFID.eq((Object)identify)));
    }

    public void cleanPendingList(String identify) {
        this.oaCtx.deleteFrom((Table)UWFL).where(new Condition[]{UserWorkflowListRepository.UWFL.UWFID.eq((Object)identify).and(UserWorkflowListRepository.UWFL.TYPE.eq((Object)UserWorkflow.LIST_PENDING.getCode()))}).execute();
    }

    public void deletePendingInfo(String id, String uid) {
        this.oaCtx.deleteFrom((Table)UWFL).where(new Condition[]{UserWorkflowListRepository.UWFL.UWFID.eq((Object)id).and(UserWorkflowListRepository.UWFL.TYPE.eq((Object)UserWorkflow.LIST_PENDING.getCode())).and(UserWorkflowListRepository.UWFL.UID.eq((Object)uid))}).execute();
    }
}

