package com.jz.jar.oa.wrapper;

import com.jz.jooq.oa.tables.pojos.User;

public class OAUserWrapper {

	private String uid;
	private String chineseName;
	private String englishName;
	private String phone;
	private CompanyWrapper company;
	private WorkAddressWrapper workAddress;
	private DepartmentWrapper department;
	private PositionWrapper position;
	private OAUserWrapper superior;
	private OAUserWrapper hr;
	private String joinDate;
	private Integer insurance;
	private Integer childFree;
	private Integer trainAgreement;
	private Integer status;

	public static OAUserWrapper of(User u) {
		return new OAUserWrapper().setUid(u.getUid()).setChineseName(u.getChineseName())
				.setEnglishName(u.getEnglishName()).setPhone(u.getPhone()).setJoinDate(u.getJoinDate())
				.setInsurance(u.getInsurance()).setChildFree(u.getChildFree()).setTrainAgreement(u.getTrainAgreement())
				.setStatus(u.getStatus());
	}

	public static OAUserWrapper ofSimple(User u) {
		return new OAUserWrapper().setUid(u.getUid()).setChineseName(u.getChineseName())
				.setEnglishName(u.getEnglishName()).setPhone(u.getPhone());
	}

	public String getUid() {
		return uid;
	}

	public OAUserWrapper setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public String getChineseName() {
		return chineseName;
	}

	public OAUserWrapper setChineseName(String chineseName) {
		this.chineseName = chineseName;
		return this;
	}

	public String getEnglishName() {
		return englishName;
	}

	public OAUserWrapper setEnglishName(String englishName) {
		this.englishName = englishName;
		return this;
	}

	public String getPhone() {
		return phone;
	}

	public OAUserWrapper setPhone(String phone) {
		this.phone = phone;
		return this;
	}

	public CompanyWrapper getCompany() {
		return company;
	}

	public OAUserWrapper setCompany(CompanyWrapper company) {
		this.company = company;
		return this;
	}

	public WorkAddressWrapper getWorkAddress() {
		return workAddress;
	}

	public OAUserWrapper setWorkAddress(WorkAddressWrapper workAddress) {
		this.workAddress = workAddress;
		return this;
	}

	public DepartmentWrapper getDepartment() {
		return department;
	}

	public OAUserWrapper setDepartment(DepartmentWrapper department) {
		this.department = department;
		return this;
	}

	public PositionWrapper getPosition() {
		return position;
	}

	public OAUserWrapper setPosition(PositionWrapper position) {
		this.position = position;
		return this;
	}

	public OAUserWrapper getSuperior() {
		return superior;
	}

	public OAUserWrapper setSuperior(OAUserWrapper superior) {
		this.superior = superior;
		return this;
	}

	public OAUserWrapper getHr() {
		return hr;
	}

	public OAUserWrapper setHr(OAUserWrapper hr) {
		this.hr = hr;
		return this;
	}

	public String getJoinDate() {
		return joinDate;
	}

	public OAUserWrapper setJoinDate(String joinDate) {
		this.joinDate = joinDate;
		return this;
	}

	public Integer getInsurance() {
		return insurance;
	}

	public OAUserWrapper setInsurance(Integer insurance) {
		this.insurance = insurance;
		return this;
	}

	public Integer getChildFree() {
		return childFree;
	}

	public OAUserWrapper setChildFree(Integer childFree) {
		this.childFree = childFree;
		return this;
	}

	public Integer getTrainAgreement() {
		return trainAgreement;
	}

	public OAUserWrapper setTrainAgreement(Integer trainAgreement) {
		this.trainAgreement = trainAgreement;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public OAUserWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

}
