/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.service;

import com.jz.jar.oa.repository.OAPositionRepository;
import com.jz.jar.oa.wrapper.PositionWrapper;
import com.jz.jooq.oa.tables.pojos.Position;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class OAPositionService {
    @Autowired
    private OAPositionRepository positionRepository;

    public List<Position> getAllPosition() {
        return this.positionRepository.getAllPosition();
    }

    public List<Position> mutiGetPositions(Collection<String> positionIds) {
        return this.positionRepository.mutiGetPositions(positionIds);
    }

    public Position getPosition(String positionId) {
        return this.positionRepository.getPosition(positionId);
    }

    public List<Position> listAllPosition(String name) {
        return this.positionRepository.listAllPosition(name);
    }

    public boolean checkName(String name, String deptId) {
        return this.positionRepository.checkName(name, deptId);
    }

    public void createPosition(String id, String deptId, String name) {
        this.positionRepository.createPosition(id, deptId, name);
    }

    public void updatePosition(String id, String deptId, String name) {
        this.positionRepository.updatePosition(id, deptId, name);
    }

    public void deletePosition(String id) {
        this.positionRepository.deletePosition(id);
    }

    public Map<String, PositionWrapper> mutiGetPositionMap(Collection<String> positionIds) {
        List<Position> list = this.positionRepository.mutiGetPositions(positionIds);
        return list.stream().collect(Collectors.toMap(it -> it.getId(), it -> PositionWrapper.of(it)));
    }

    public Map<String, PositionWrapper> mutiGetSimplePositionMap(Collection<String> positionIds) {
        List<Position> list = this.positionRepository.mutiGetPositions(positionIds);
        return list.stream().collect(Collectors.toMap(it -> it.getId(), it -> PositionWrapper.ofSimple(it)));
    }

    public PositionWrapper getPositionWrapper(String positionId) {
        Position p = this.positionRepository.getPosition(positionId);
        return p != null ? PositionWrapper.of(p) : null;
    }

    public void deletePositionDeptId(String deptId) {
        this.positionRepository.deletePositionDeptId(deptId);
    }
}

