/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.UserVacationUsed;
import com.jz.jooq.oa.tables.records.UserVacationUsedRecord;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserVacationUsedRepository
extends OABaseRepository {
    private static final UserVacationUsed V = Tables.USER_VACATION_USED;

    public List<com.jz.jooq.oa.tables.pojos.UserVacationUsed> getUserVacationUsed(List<String> filterUids) {
        return this.oaCtx.selectFrom((Table)V).where(new Condition[]{UserVacationUsedRepository.V.UID.in(filterUids)}).fetchInto(com.jz.jooq.oa.tables.pojos.UserVacationUsed.class);
    }

    public com.jz.jooq.oa.tables.pojos.UserVacationUsed getUserVacationUsed(String uid) {
        return (com.jz.jooq.oa.tables.pojos.UserVacationUsed)this.oaCtx.selectFrom((Table)V).where(new Condition[]{UserVacationUsedRepository.V.UID.eq((Object)uid)}).fetchAnyInto(com.jz.jooq.oa.tables.pojos.UserVacationUsed.class);
    }

    public void addVacationUsed(String uid, Map<String, Double> type2day) {
        ArrayList records = Lists.newArrayList();
        for (Map.Entry<String, Double> entry : type2day.entrySet()) {
            UserVacationUsedRecord record = new UserVacationUsedRecord();
            record.setUid(uid);
            record.setType(entry.getKey());
            record.setNum(new BigDecimal(entry.getValue()));
            record.setLastUpdated(Long.valueOf(System.currentTimeMillis()));
            records.add(record);
        }
        this.oaCtx.batchInsert((Collection)records).execute();
    }

    public Map<String, Double> getUsedVacation(String uid) {
        List list = this.oaCtx.select((SelectField)UserVacationUsedRepository.V.TYPE.as("type"), (SelectField)UserVacationUsedRepository.V.NUM.as("num")).from((TableLike)V).where(new Condition[]{UserVacationUsedRepository.V.UID.eq((Object)uid)}).groupBy(new GroupField[]{UserVacationUsedRepository.V.TYPE}).fetchMaps();
        HashMap map = Maps.newHashMap();
        list.forEach(it -> map.put(MapUtils.getString((Map)it, (Object)"type"), MapUtils.getDouble((Map)it, (Object)"num")));
        return map;
    }

    public void cleanVacationUsed(String uid) {
        this.oaCtx.deleteFrom((Table)V).where(new Condition[]{UserVacationUsedRepository.V.UID.eq((Object)uid)}).execute();
    }

    public void subtractVacationUsed(String uid, String leaveType, double leaveDay) {
        this.oaCtx.update((Table)V).set((Field)UserVacationUsedRepository.V.NUM, UserVacationUsedRepository.V.NUM.sub((Number)leaveDay)).set((Field)UserVacationUsedRepository.V.LAST_UPDATED, (Object)System.currentTimeMillis()).where(new Condition[]{UserVacationUsedRepository.V.UID.eq((Object)uid).and(UserVacationUsedRepository.V.TYPE.eq((Object)leaveType))}).execute();
    }
}

