/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.wrapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jz.common.utils.text.StringTools;
import com.jz.jooq.oa.tables.pojos.User;
import com.jz.jooq.oa.tables.pojos.UserWorkflowHandler;
import com.jz.jooq.oa.tables.pojos.UserWorkflowHandlerAttachment;
import com.jz.jooq.oa.tables.pojos.WorkflowSetting;
import java.util.List;

public class WorkflowHandler {
    private String uid;
    private String name;
    private String handleName;
    private Integer step;
    private Boolean isAddPosition;
    private Boolean isCarbonCopy;
    private String positionName;
    private Boolean isPassed;
    private String remarks;
    private Boolean isAddSignature;
    private String addSignatureReason;
    private Long auditTime;
    private List<UserWorkflowHandlerAttachment> attachments;
    private String extType;
    private Object extData;

    public static WorkflowHandler of(String uid, WorkflowSetting workflow) {
        return WorkflowHandler.of(uid, workflow, false);
    }

    public static WorkflowHandler of(String uid, WorkflowSetting workflow, boolean isAddPosition) {
        WorkflowHandler handler = new WorkflowHandler().setUid(uid).setIsAddPosition(isAddPosition).setIsCarbonCopy(workflow.getCarbonCopy() > 0);
        if (workflow.getCarbonCopy() > 0) {
            return handler;
        }
        handler.setHandleName(workflow.getHandleName());
        if (workflow.getIsExt() > 0) {
            handler.setExtType(workflow.getType());
        }
        return handler;
    }

    public static WorkflowHandler of(User user, UserWorkflowHandler handler) {
        WorkflowHandler result = new WorkflowHandler().setUid(user.getUid()).setName(user.getChineseName()).setHandleName(handler.getHandleName()).setStep(handler.getStep()).setPositionName(handler.getPositionName()).setExtType(handler.getExtType());
        if (null != handler.getResult()) {
            result.setIsPassed(handler.getResult() == 1).setRemarks(handler.getRemarks()).setAuditTime(handler.getLastUpdate());
        }
        if (StringTools.isNotEmptyAndBlank((String)handler.getReason())) {
            result.setIsAddSignature(true).setAddSignatureReason(handler.getReason());
        }
        return result;
    }

    public String getUid() {
        return this.uid;
    }

    public WorkflowHandler setUid(String uid) {
        this.uid = uid;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public WorkflowHandler setName(String name) {
        this.name = name;
        return this;
    }

    public String getHandleName() {
        return this.handleName;
    }

    public WorkflowHandler setHandleName(String handleName) {
        this.handleName = handleName;
        return this;
    }

    public Integer getStep() {
        return this.step;
    }

    public WorkflowHandler setStep(Integer step) {
        this.step = step;
        return this;
    }

    @JsonIgnore
    public Boolean getIsAddPosition() {
        return this.isAddPosition;
    }

    public WorkflowHandler setIsAddPosition(Boolean isAddPosition) {
        this.isAddPosition = isAddPosition;
        return this;
    }

    public Boolean getIsCarbonCopy() {
        return this.isCarbonCopy;
    }

    public WorkflowHandler setIsCarbonCopy(Boolean isCarbonCopy) {
        this.isCarbonCopy = isCarbonCopy;
        return this;
    }

    public String getPositionName() {
        return this.positionName;
    }

    public WorkflowHandler setPositionName(String positionName) {
        this.positionName = positionName;
        return this;
    }

    public Boolean getIsPassed() {
        return this.isPassed;
    }

    public WorkflowHandler setIsPassed(Boolean isPassed) {
        this.isPassed = isPassed;
        return this;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public WorkflowHandler setRemarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    public Boolean getIsAddSignature() {
        return this.isAddSignature;
    }

    public WorkflowHandler setIsAddSignature(Boolean isAddSignature) {
        this.isAddSignature = isAddSignature;
        return this;
    }

    public String getAddSignatureReason() {
        return this.addSignatureReason;
    }

    public WorkflowHandler setAddSignatureReason(String addSignatureReason) {
        this.addSignatureReason = addSignatureReason;
        return this;
    }

    public Long getAuditTime() {
        return this.auditTime;
    }

    public WorkflowHandler setAuditTime(Long auditTime) {
        this.auditTime = auditTime;
        return this;
    }

    public List<UserWorkflowHandlerAttachment> getAttachments() {
        return this.attachments;
    }

    public WorkflowHandler setAttachments(List<UserWorkflowHandlerAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public String getExtType() {
        return this.extType;
    }

    public WorkflowHandler setExtType(String extType) {
        this.extType = extType;
        return this;
    }

    public Object getExtData() {
        return this.extData;
    }

    public WorkflowHandler setExtData(Object extData) {
        this.extData = extData;
        return this;
    }
}

