package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserCollect;

@Lazy
@Repository
public class UserCollectRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCollect UC = Tables.USER_COLLECT;

	public void addCollect(String uid, String pid) {
		mediaCtx.insertInto(UC, UC.UID, UC.PID, UC.CREATE_TIME).values(uid, pid, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public List<UserCollect> getCollect(String uid) {
		return mediaCtx.selectFrom(UC).where(UC.UID.eq(uid)).orderBy(UC.CREATE_TIME.desc())
				.fetchInto(UserCollect.class);
	}

	public int countCollect(String uid) {
		return mediaCtx.fetchCount(UC, UC.UID.eq(uid));
	}

	public List<UserCollect> getCollect(String uid, int start, int size) {
		return mediaCtx.selectFrom(UC).where(UC.UID.eq(uid)).orderBy(UC.CREATE_TIME.desc()).limit(start, size)
				.fetchInto(UserCollect.class);
	}

	public boolean isCollect(String uid, String pid) {
		return mediaCtx.fetchExists(UC, UC.UID.eq(uid).and(UC.PID.eq(pid)));
	}

	public void deleteCollect(String uid, String pid) {
		mediaCtx.deleteFrom(UC).where(UC.UID.eq(uid).and(UC.PID.eq(pid))).execute();
	}

	public List<String> getExistCollect(String uid, Collection<String> pids) {
		return mediaCtx.select(UC.PID).from(UC).where(UC.UID.eq(uid).and(UC.PID.in(pids))).fetchInto(String.class);
	}
}
