package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.SourceStatus;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class FeedbackRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.Feedback FB = Tables.FEEDBACK;

	public void save(BrandEnum brand, String sid, String uid, String suid, String content, String contact) {
		mediaCtx.insertInto(FB, FB.SID, FB.UID, FB.SUID, FB.BRAND, FB.CONTENT, FB.CONTACT, FB.CREATE_TIME, FB.STATUS)
				.values(sid, uid, suid, brand.name(), content, contact, System.currentTimeMillis(),
						SourceStatus.verifying.getCode())
				.execute();
	}
}
