package com.jz.jar.media.repository;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.enums.SourceStatus;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class UserModifyAuditRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserModifyAudit UMA = Tables.USER_MODIFY_AUDIT;

	private Condition getCondition(String uid, String suid) {
		return UMA.UID.eq(uid).and(UMA.SUID.eq(suid)).and(UMA.STATUS.eq(SourceStatus.verifying.getCode()));
	}

	public void refreshUserModify(String uid, String suid, String name, String avatar) {
		String tmpSuid = StringTools.ternary(suid);
		Condition condition = getCondition(uid, tmpSuid);
		long timeMillis = System.currentTimeMillis();
		if (mediaCtx.fetchExists(UMA, condition)) {
			mediaCtx.update(UMA).set(UMA.NAME, name).set(UMA.AVATAR, avatar).set(UMA.LAST_UPDATE, timeMillis)
					.where(condition).execute();
			return;
		}
		mediaCtx.insertInto(UMA, UMA.UID, UMA.SUID, UMA.NAME, UMA.AVATAR, UMA.STATUS, UMA.LAST_UPDATE)
				.values(uid, tmpSuid, name, avatar, SourceStatus.verifying.getCode(), timeMillis).execute();
	}
}
