/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.CtxType;
import com.jz.jar.media.enums.SourceStatus;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.CommentInfo;
import com.jz.jooq.media.tables.records.CommentInfoRecord;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class CommentInfoRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.CommentInfo CI = Tables.COMMENT_INFO;

    public void addComment(BrandEnum brand, String id, CtxType type, String sourceId, String uid, String content, String replyId) {
        CommentInfoRecord record = new CommentInfoRecord();
        record.setId(id);
        record.setBrand(brand.name());
        record.setSourceType(type.name());
        record.setSourceId(sourceId);
        record.setUid(uid);
        record.setContent(content);
        record.setStatus(Integer.valueOf(SourceStatus.verifying.getCode()));
        record.setReplyid(replyId);
        long timeMillis = System.currentTimeMillis();
        record.setCreateTime(Long.valueOf(timeMillis));
        record.setLastUpdate(Long.valueOf(timeMillis));
        this.mediaCtx.insertInto((Table)CI).set((Record)record).execute();
    }

    private Condition getCondition(BrandEnum brand, CtxType type, String sourceId) {
        return CommentInfoRepository.CI.BRAND.eq((Object)brand.name()).and(CommentInfoRepository.CI.SOURCE_TYPE.eq((Object)type.name())).and(CommentInfoRepository.CI.SOURCE_ID.eq((Object)sourceId)).and(CommentInfoRepository.CI.STATUS.in((Object[])new Integer[]{SourceStatus.verifying.getCode(), SourceStatus.online.getCode()}));
    }

    public int countCommentInfo(BrandEnum brand, CtxType type, String sourceId) {
        return this.mediaCtx.fetchCount((Table)CI, this.getCondition(brand, type, sourceId));
    }

    public List<CommentInfo> getCommentInfo(BrandEnum brand, CtxType type, String sourceId, int start, int size) {
        return this.mediaCtx.select((SelectField)CommentInfoRepository.CI.ID, (SelectField)CommentInfoRepository.CI.UID, (SelectField)CommentInfoRepository.CI.CONTENT, (SelectField)CommentInfoRepository.CI.REPLYID, (SelectField)CommentInfoRepository.CI.CREATE_TIME).from((TableLike)CI).where(new Condition[]{this.getCondition(brand, type, sourceId)}).orderBy(CommentInfoRepository.CI.CREATE_TIME.desc()).limit(start, size).fetchInto(CommentInfo.class);
    }

    public CommentInfo getCommentInfo(BrandEnum brand, String id) {
        return (CommentInfo)this.mediaCtx.selectFrom((Table)CI).where(new Condition[]{CommentInfoRepository.CI.ID.eq((Object)id).and(CommentInfoRepository.CI.BRAND.eq((Object)brand.name()))}).fetchAnyInto(CommentInfo.class);
    }

    public List<CommentInfo> getCommentUids(Collection<String> ids) {
        return this.mediaCtx.select((SelectField)CommentInfoRepository.CI.ID, (SelectField)CommentInfoRepository.CI.UID).from((TableLike)CI).where(new Condition[]{CommentInfoRepository.CI.ID.in(ids)}).fetchInto(CommentInfo.class);
    }
}

