package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TagInfo;

@Lazy
@Repository
public class TagInfoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TagInfo TI = Tables.TAG_INFO;

	public List<TagInfo> findTags(List<String> tagIds) {
		return mediaCtx.selectFrom(TI).where(TI.ID.in(tagIds)).orderBy(TI.ID).fetchInto(TagInfo.class);
	}

	public TagInfo getTag(String tagId) {
		return mediaCtx.selectFrom(TI).where(TI.ID.eq(tagId)).fetchAnyInto(TagInfo.class);
	}

	public List<TagInfo> getTagsForDirections(Collection<String> directions) {
		return mediaCtx.selectFrom(TI).where(TI.DIRECTION.in(directions)).fetchInto(TagInfo.class);
	}
}
