/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Lists;
import com.jz.jar.media.enums.SourceStatus;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.TestsPluses;
import com.jz.jooq.media.tables.TestsQuestion;
import com.jz.jooq.media.tables.TestsScores;
import com.jz.jooq.media.tables.pojos.TestsMultipleOptionScore;
import com.jz.jooq.media.tables.pojos.TestsOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.jooq.Condition;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class TestsRepository
extends MediaBaseRepository {
    private static final TestsQuestion QUESTION = Tables.TESTS_QUESTION;
    private static final com.jz.jooq.media.tables.TestsOption OPTION = Tables.TESTS_OPTION;
    private static final TestsPluses PLUS = Tables.TESTS_PLUSES;
    private static final com.jz.jooq.media.tables.TestsMultipleOptionScore MULTIPLE = Tables.TESTS_MULTIPLE_OPTION_SCORE;
    private static final TestsScores SCORES = Tables.TESTS_SCORES;

    public List<com.jz.jooq.media.tables.pojos.TestsQuestion> getOnlineQuestion(String crowd) {
        return this.mediaCtx.selectFrom((Table)QUESTION).where(new Condition[]{TestsRepository.QUESTION.CROWD.eq((Object)crowd).and(TestsRepository.QUESTION.STATUS.eq((Object)SourceStatus.online.getCode()))}).orderBy(TestsRepository.QUESTION.SEQ.asc()).fetchInto(com.jz.jooq.media.tables.pojos.TestsQuestion.class);
    }

    public List<TestsOption> getOptions(Collection<String> questionIds) {
        return this.mediaCtx.selectFrom((Table)OPTION).where(new Condition[]{TestsRepository.OPTION.QID.in(questionIds)}).orderBy(TestsRepository.OPTION.SEQ.asc()).fetchInto(TestsOption.class);
    }

    public List<com.jz.jooq.media.tables.pojos.TestsPluses> getPluses(Collection<String> questionIds, int age) {
        return this.mediaCtx.selectFrom((Table)PLUS).where(new Condition[]{TestsRepository.PLUS.QID.in(questionIds).and(TestsRepository.PLUS.MAX_AGE.ge((Object)age)).and(TestsRepository.PLUS.MIN_AGE.le((Object)age))}).fetchInto(com.jz.jooq.media.tables.pojos.TestsPluses.class);
    }

    public List<TestsMultipleOptionScore> getMultipleScore(Collection<String> questionIds) {
        return this.mediaCtx.selectFrom((Table)MULTIPLE).where(new Condition[]{TestsRepository.MULTIPLE.QID.in(questionIds)}).fetchInto(TestsMultipleOptionScore.class);
    }

    public boolean existScore(String uid, String suid, String crowd) {
        return this.mediaCtx.fetchExists((Table)SCORES, TestsRepository.SCORES.UID.eq((Object)uid).and(TestsRepository.SCORES.SUID.eq((Object)suid)).and(TestsRepository.SCORES.CROWD.eq((Object)crowd)));
    }

    public void refreshScore(String uid, String suid, String crowd, List<Triple<String, Integer, String>> direction2Score2Content) {
        long timeMillis = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO `tests_scores` ");
        sb.append("(`uid`, `suid` ,`crowd`, `direction` ,`score` ,`content` ,`create_time` )");
        sb.append("VALUES (?, ?, ?, ?, ?, ?, ?)");
        sb.append("ON DUPLICATE KEY UPDATE `score` = ?, `content` = ?, `create_time` = ?");
        ArrayList batchArgs = Lists.newArrayList();
        for (Triple<String, Integer, String> triple : direction2Score2Content) {
            batchArgs.add(new Object[]{uid, suid, crowd, triple.getLeft(), triple.getMiddle(), triple.getRight(), timeMillis, triple.getMiddle(), triple.getRight(), timeMillis});
        }
        this.mediaJdbcTemplate.batchUpdate(sb.toString(), (List)batchArgs);
    }
}

