package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.tuple.Triple;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jar.media.enums.SourceStatus;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.StudentTestsMultipleScore;
import com.jz.jooq.media.tables.pojos.StudentTestsOptions;
import com.jz.jooq.media.tables.pojos.StudentTestsPluses;
import com.jz.jooq.media.tables.pojos.StudentTestsQuestion;

@Lazy
@Repository
public class StudentTestsRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.StudentTestsQuestion QUESTION = Tables.STUDENT_TESTS_QUESTION;
	private static final com.jz.jooq.media.tables.StudentTestsOptions OPTION = Tables.STUDENT_TESTS_OPTIONS;
	private static final com.jz.jooq.media.tables.StudentTestsPluses PLUS = Tables.STUDENT_TESTS_PLUSES;
	private static final com.jz.jooq.media.tables.StudentTestsMultipleScore MULTIPLE = Tables.STUDENT_TESTS_MULTIPLE_SCORE;

	public List<StudentTestsQuestion> getOnlineQuestion() {
		return mediaCtx.selectFrom(QUESTION).where(QUESTION.STATUS.eq(SourceStatus.online.getCode()))
				.orderBy(QUESTION.SEQ.asc()).fetchInto(StudentTestsQuestion.class);
	}

	public List<StudentTestsOptions> getOptions(Collection<String> questionIds) {
		return mediaCtx.selectFrom(OPTION).where(OPTION.QID.in(questionIds)).orderBy(OPTION.SEQ.asc())
				.fetchInto(StudentTestsOptions.class);
	}

	public List<StudentTestsPluses> getPluses(Collection<String> questionIds, int age) {
		return mediaCtx.selectFrom(PLUS)
				.where(PLUS.QID.in(questionIds).and(PLUS.MAX_AGE.ge(age)).and(PLUS.MIN_AGE.le(age)))
				.fetchInto(StudentTestsPluses.class);
	}

	public List<StudentTestsMultipleScore> getMultipleScore(Collection<String> questionIds) {
		return mediaCtx.selectFrom(MULTIPLE).where(MULTIPLE.QID.in(questionIds))
				.fetchInto(StudentTestsMultipleScore.class);
	}

	public void refreshStudentScore(String suid, List<Triple<String, Integer, String>> direction2Score2Content) {
		long timeMillis = System.currentTimeMillis();
		StringBuffer sb = new StringBuffer();
		sb.append("INSERT INTO `student_tests_scores` ");
		sb.append("(`suid` ,`direction` ,`score` ,`content` ,`create_time` )");
		sb.append("VALUES (?, ?, ?, ?, ?)");
		sb.append("ON DUPLICATE KEY UPDATE `score` = ?, `content` = ?, `create_time` = ?");
		List<Object[]> batchArgs = Lists.newArrayList();
		for (Triple<String, Integer, String> triple : direction2Score2Content) {
			batchArgs.add(new Object[] { suid, triple.getLeft(), triple.getMiddle(), triple.getRight(), timeMillis,
					triple.getMiddle(), triple.getRight(), timeMillis });
		}
		mediaJdbcTemplate.batchUpdate(sb.toString(), batchArgs);
	}
}
