package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class StudentPlayTotalRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.StudentPlayTotal SPT = Tables.STUDENT_PLAY_TOTAL;

	public void refreshPlayTotal(BrandEnum brand, String suid, int playLength, int videoCnt) {
		long timeMillis = System.currentTimeMillis();
		mediaCtx.insertInto(SPT, SPT.BRAND, SPT.SUID, SPT.PLAY_TIME, SPT.VIDEO_CNT, SPT.CREATE_TIME, SPT.LAST_UPDATE)
				.values(brand.name(), suid, playLength, videoCnt, timeMillis, timeMillis).onDuplicateKeyUpdate()
				.set(SPT.PLAY_TIME, SPT.PLAY_TIME.add(playLength)).set(SPT.VIDEO_CNT, SPT.VIDEO_CNT.add(videoCnt))
				.set(SPT.LAST_UPDATE, timeMillis).execute();
	}

}
